<?php
session_start();
include 'dbconn.php';

if (!isset($_SESSION['user_id'])) {
    echo "Login required";
    exit;
}

$user_id = $_SESSION['user_id'];

// Get order_id (from POST or GET)
$order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : (isset($_GET['order_id']) ? intval($_GET['order_id']) : 0);

if ($order_id <= 0) {
    echo "Invalid request";
    exit;
}

// Verify order
$sql = "SELECT order_date, status FROM orders WHERE id = ? AND user_id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("ii", $order_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();
$order = $result->fetch_assoc();

if (!$order) {
    echo "Order not found";
    exit;
}

$order_time   = strtotime($order['order_date']);
$current_time = time();
$time_diff    = $current_time - $order_time;

// Allow cancel only within 1 hour and if still Processing
if ($time_diff > 3600 || $order['status'] != 'Pending') {
    echo "Cancellation not allowed";
    exit;
}

// Cancel order
$update = $mysqli->prepare("UPDATE orders SET status = 'Cancelled' WHERE id = ?");
$update->bind_param("i", $order_id);
$update->execute();

// Redirect back with success message
header("Location: my-account.php?status=cancelled&order_id=" . $order_id);
exit;
?>
