<?php
session_start();
require 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: forgot_password.php');
    exit;
}

$email = isset($_POST['email']) ? trim($_POST['email']) : '';
if (! filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $_SESSION['error'] = 'Please enter a valid email.';
    header('Location: forgot_password.php');
    exit;
}

// Check if email exists in customers table
$stmt = $mysqli->prepare("SELECT id FROM users WHERE email = ?");
$stmt->bind_param('s', $email);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows === 0) {
    // For security, we show a generic message but still do nothing
    $_SESSION['success'] = 'If this email is registered, a verification code has been sent.';
    header('Location: verify_code.php');
    exit;
}
$stmt->close();

// Generate 6-digit numeric OTP
$code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);

// Set expiry (5 minutes from now)
$expires_at = date('Y-m-d H:i:s', time() + 5 * 60);

// Insert into password_resets (mark used=0). You may choose to soft-delete old entries.
$insert = $mysqli->prepare("INSERT INTO password_resets (email, code, expires_at, used) VALUES (?, ?, ?, 0)");
$insert->bind_param('sss', $email, $code, $expires_at);
$ok = $insert->execute();
$insert->close();

if (! $ok) {
    $_SESSION['error'] = 'Server error. Please try again later.';
    header('Location: forgot_password.php');
    exit;
}

// Send email - try mail() by default. You can replace with PHPMailer (see notes).
$subject = "Your password reset code";
$message = "Hello,\n\nYour password reset verification code is: {$code}\n\nThis code will expire in 5 minutes.\n\nIf you didn't request this, please ignore this email.";
$headers = "From: no-reply@yourdomain.com\r\nReply-To: no-reply@yourdomain.com\r\n";

// Try PHP mail()
$mail_sent = @mail($email, $subject, $message, $headers);

// If mail() fails, still proceed but inform user to check spam or contact support
if ($mail_sent) {
    $_SESSION['success'] = 'Verification code sent to your email.';
} else {
    // Not fatal; still save the code so user (or admin) can debug. You could log this error.
    $_SESSION['warning'] = 'Unable to send email via mail(); if you don\'t receive it, contact site admin.';
    $_SESSION['success'] = 'Verification code generated. Check your email (or spam).';
}

// store the email in session temporarily for verification step
$_SESSION['reset_email'] = $email;

// redirect to verify page
header('Location: verify_code.php');
exit;
