<?php
include 'contctn.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = (int) $_POST['order_id'];
    $status   = mysqli_real_escape_string($db, $_POST['status']);

    // Update DB
    $q = "UPDATE orders SET status = '$status' WHERE id = $order_id";
    if (mysqli_query($db, $q)) {

        // Fetch customer + product details
        $order_sql = "SELECT * FROM orders WHERE id = $order_id";
        $order_res = mysqli_query($db, $order_sql);
        $order     = mysqli_fetch_assoc($order_res);

        $items_sql = "SELECT oi.*, p.pname, p.pthumb
                      FROM order_items oi
                      JOIN product p ON oi.product_id = p.id
                      WHERE oi.order_id = $order_id";
        $items_res = mysqli_query($db, $items_sql);

        // Build Products HTML
        $products_html = '';
        while ($item = mysqli_fetch_assoc($items_res)) {
            $img = ! empty($item['pthumb'])
                ? 'https://bhavik.kitret.com/craftsy-angel/Admin/uploads/thumb/' . $item['pthumb']
                : 'https://yourdomain.com/items/noimage.jpg';

            $products_html .= "
                <tr>
                    <td><img src='$img' width='60'></td>
                    <td>{$item['pname']}</td>
                    <td>{$item['quantity']}</td>
                    <td>₹{$item['total']}</td>
                </tr>";
        }

        // ✅ Status Colors & Icons
        $statusConfig = [
            "Accepted"   => ["color" => "#28a745", "icon" => "✅", "bg" => "#28a745"],
            "Processing" => ["color" => "#007BFF", "icon" => "🔄", "bg" => "#007BFF"],
            "Cancelled"  => ["color" => "#dc3545", "icon" => "❌", "bg" => "#dc3545"],
            "Delivered"  => ["color" => "#FFB300", "icon" => "📦", "bg" => "#FFB300"],
        ];

        $color = $statusConfig[$status]['color'] ?? "#333";
        $icon  = $statusConfig[$status]['icon'] ?? "ℹ️";
        $bg    = $statusConfig[$status]['bg'] ?? "#333";

        // ✅ Email Subject & Body
        $subject = "Order #$order_id Status Update - {$order['first_name']} {$order['last_name']}";
        $message = "
        <!DOCTYPE html>
        <html lang='en'>
        <head>
          <meta charset='UTF-8'>
          <title>Order Status Update</title>
        </head>
        <body style='margin:0;padding:0;background-color:#FAFAFA;font-family:Arial,sans-serif;'>
          <div style='background-color:#FAFAFA;padding:20px 0;'>
            <table align='center' width='600' cellpadding='0' cellspacing='0'
                   style='background:#fff;border:1px solid $color;border-radius:8px;overflow:hidden;'>

              <!-- ✅ Logo -->
              <tr>
                <td align='center' style='padding:20px;'>
                  <img src='https://fjldusj.stripocdn.email/content/guids/CABINET_16e121cdd3958cc292dbd12ff9305248140210590ab6a793520a0bdc45bd7bb7/images/logo.png'
                       alt='CrafsyAngel Logo' width='150' height='80' style='display:block;margin:0 auto;'>
                </td>
              </tr>

              <!-- ✅ Status Header -->
              <tr>
                <td align='center' style='padding:20px;background:$bg;color:#fff;font-size:20px;font-weight:bold;'>
                  $icon Your Order is $status
                </td>
              </tr>

              <!-- ✅ Message -->
              <tr>
                <td style='padding:20px;color:#333;font-size:14px;line-height:1.6;'>
                  <p>Dear <b>{$order['first_name']} {$order['last_name']}</b>,</p>
                  <p>Your order <b>#$order_id</b> has been updated to:
                     <b style='color:$color;'>$status</b>.</p>

                  <p><b>Order Summary:</b></p>
                  <table width='100%' cellspacing='0' cellpadding='0'
                         style='border-collapse:collapse;margin-top:10px;background:#fff;'>
                    <tr style='background:#f8f8f8;'>
                      <th style='padding:10px;border:1px solid #ddd;'>Image</th>
                      <th style='padding:10px;border:1px solid #ddd;'>Product</th>
                      <th style='padding:10px;border:1px solid #ddd;'>Qty</th>
                      <th style='padding:10px;border:1px solid #ddd;'>Total</th>
                    </tr>
                    $products_html
                    <tr>
                      <td colspan='3' style='padding:10px;text-align:right;font-weight:bold;border:1px solid #ddd;'>Grand Total</td>
                      <td style='padding:10px;text-align:right;border:1px solid #ddd;'><b>₹{$order['grand_total']}</b></td>
                    </tr>
                  </table>

                  <p style='margin-top:20px;'>Thank you for shopping with <b>CrafsyAngel</b>!</p>
                </td>
              </tr>

              <!-- ✅ Footer -->
              <tr>
                <td style='background:#f1f1f1;padding:10px;text-align:center;font-size:12px;color:#555;'>
                  © " . date("Y") . " CrafsyAngel. All rights reserved.
                </td>
              </tr>
            </table>
          </div>

</body>
        </html>";

        // ✅ Send Email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: info@bhavik.kitret.com";

        mail($order['email'], $subject, $message, $headers);

        header("Location: view-order.php?id=$order_id&msg=updated");
        exit;
    }
}
