<?php
session_start();
include 'dbconn.php';

$is_logged_in = isset($_SESSION['user_id']);
$user_id      = $is_logged_in ? $_SESSION['user_id'] : null;

if ($is_logged_in) {
    // Logged-in user → clear cart from database
    $query = "DELETE FROM cart WHERE user_id = ?";
    $stmt  = $mysqli->prepare($query);
    $stmt->bind_param("i", $user_id);
    if ($stmt->execute()) {
        $msg = "Cart cleared successfully.";
    } else {
        $msg = "Failed to clear cart.";
    }
    $stmt->close();

} else {
    // Guest → clear cart from session
    if (isset($_SESSION['cart'])) {
        unset($_SESSION['cart']);
        $msg = "Cart cleared successfully.";
    } else {
        $msg = "Cart is already empty.";
    }
}

// Redirect back to cart page with message
header("Location: my_cart.php?msg=" . urlencode($msg));
exit;
