<?php
include 'dbconn.php';
session_start();

// Check if user is logged in
$is_logged_in = isset($_SESSION['user_id']);
$user_id      = $is_logged_in ? $_SESSION['user_id'] : null;

// Get cart ID from URL
$cart_id = isset($_GET['id']) ? intval($_GET['id']) : -1;

if ($cart_id < 0) {
    // Invalid ID
    header("Location: my_cart.php?msg=Invalid item");
    exit;
}

if ($is_logged_in) {
    // Logged-in user → delete from database
    $sql  = "DELETE FROM cart WHERE id = ? AND user_id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("ii", $cart_id, $user_id);
    $stmt->execute();
    $stmt->close();
    $msg = "Item removed from cart.";

} else {
    // Guest → delete from session cart
    if (isset($_SESSION['cart'][$cart_id])) {
        unset($_SESSION['cart'][$cart_id]);
        $msg = "Item removed from cart.";
    } else {
        $msg = "Item not found in cart.";
    }
}

// Redirect back to cart page with message
header("Location: my_cart.php?msg=" . urlencode($msg));
exit;
