<?php
session_start();
require 'dbconn.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id  = $_SESSION['user_id'];
$fullName = trim($_POST['full_name'] ?? '');
$address  = trim($_POST['address'] ?? '');
$city     = trim($_POST['city'] ?? '');
$state    = trim($_POST['state'] ?? '');
$zip      = trim($_POST['zip'] ?? '');
$country  = trim($_POST['country'] ?? '');

$sql = "UPDATE users 
        SET username = ?, address = ?, city = ?, state = ?, zip = ?, country = ? 
        WHERE id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("ssssssi", $fullName, $address, $city, $state, $zip, $country, $user_id);

if ($stmt->execute()) {
    $_SESSION['success_msg'] = "Address updated successfully.";
} else {
    $_SESSION['error_msg'] = "Error updating address.";
}

header("Location: my-account.php#address");
exit;
