<?php
session_start();
require 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: reset_password.php');
    exit;
}

// Security: check flag allowing reset
if (empty($_SESSION['can_reset']) || $_SESSION['can_reset'] !== true || empty($_SESSION['reset_email'])) {
    $_SESSION['error'] = 'Unauthorized action. Please go through the password reset flow.';
    header('Location: forgot_password.php');
    exit;
}

$email            = $_SESSION['reset_email'];
$new_password     = isset($_POST['new_password']) ? trim($_POST['new_password']) : '';
$confirm_password = isset($_POST['confirm_password']) ? trim($_POST['confirm_password']) : '';

if (empty($new_password) || empty($confirm_password)) {
    $_SESSION['error'] = 'Please fill both password fields.';
    header('Location: reset_password.php');
    exit;
}

if ($new_password !== $confirm_password) {
    $_SESSION['error'] = 'Passwords do not match.';
    header('Location: reset_password.php');
    exit;
}

if (strlen($new_password) < 6) {
    $_SESSION['error'] = 'Password must be at least 6 characters long.';
    header('Location: reset_password.php');
    exit;
}

// 🔒 Store password as MD5
$hash = md5($new_password);

$update = $mysqli->prepare("UPDATE users SET password = ? WHERE email = ?");
$update->bind_param('ss', $hash, $email);
$ok = $update->execute();
$update->close();

if ($ok) {
    // Mark the password reset as used
    $cleanup = $mysqli->prepare("UPDATE password_resets SET used = 1 WHERE email = ?");
    $cleanup->bind_param('s', $email);
    $cleanup->execute();
    $cleanup->close();

    unset($_SESSION['can_reset']);
    unset($_SESSION['reset_email']);

    $_SESSION['success'] = 'Password updated successfully. You can now login.';
    header('Location: login.html');
    exit;
} else {
    $_SESSION['error'] = 'Unable to update password. Try again later.';
    header('Location: reset_password.php');
    exit;
}
