<?php
session_start();
include 'dbconn.php';

// Check if user is logged in
$is_logged_in = isset($_SESSION['user_id']);
$user_id = $is_logged_in ? $_SESSION['user_id'] : null;

// Get product data from form
$product_id = isset($_POST['product_id']) ? intval($_POST['product_id']) : 0;
$quantity   = isset($_POST['quantity']) ? intval($_POST['quantity']) : 1;
$color      = isset($_POST['color']) ? mysqli_real_escape_string($mysqli, $_POST['color']) : '';

// ✅ New personalization fields
$personalize_name = isset($_POST['personalize_name']) ? mysqli_real_escape_string($mysqli, $_POST['personalize_name']) : '';
$personalize_message = isset($_POST['personalize_message']) ? mysqli_real_escape_string($mysqli, $_POST['personalize_message']) : '';

if ($product_id > 0) {
    if ($is_logged_in) {
        // ✅ Save in DB for logged-in users
        $check = mysqli_query($mysqli,
            "SELECT * FROM cart 
             WHERE user_id='$user_id' 
             AND product_id='$product_id' 
             AND color='$color'
             AND personalize_name='$personalize_name'
             AND personalize_message='$personalize_message'"
        );

        if (mysqli_num_rows($check) > 0) {
            mysqli_query($mysqli,
                "UPDATE cart 
                 SET quantity = quantity + $quantity 
                 WHERE user_id='$user_id' 
                 AND product_id='$product_id' 
                 AND color='$color'
                 AND personalize_name='$personalize_name'
                 AND personalize_message='$personalize_message'"
            );
        } else {
            mysqli_query($mysqli,
                "INSERT INTO cart (user_id, product_id, quantity, color, personalize_name, personalize_message) 
                 VALUES ('$user_id', '$product_id', '$quantity', '$color', '$personalize_name', '$personalize_message')"
            );
        }
    } else {
        // ✅ Save in SESSION for guest users
        if (!isset($_SESSION['cart'])) {
            $_SESSION['cart'] = [];
        }

        $found = false;
        foreach ($_SESSION['cart'] as &$item) {
            if (
                $item['product_id'] == $product_id && 
                $item['color'] == $color &&
                $item['personalize_name'] == $personalize_name &&
                $item['personalize_message'] == $personalize_message
            ) {
                $item['quantity'] += $quantity;
                $found = true;
                break;
            }
        }

        if (!$found) {
            $_SESSION['cart'][] = [
                'product_id' => $product_id,
                'quantity'   => $quantity,
                'color'      => $color,
                'personalize_name' => $personalize_name,
                'personalize_message' => $personalize_message
            ];
        }
    }
}

// redirect to cart page
header("Location: my_cart.php");
exit;
?>
