<?php
    session_start();

    include 'dbconn.php';
    $user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : 0;

    $cart_id  = isset($_GET['cart_id']) ? (int) $_GET['cart_id'] : 0;
    $cart_ids = isset($_GET['cart_ids']) ? explode(",", $_GET['cart_ids']) : [];

    $products_to_checkout = [];
    $grand_total          = 0;

    if ($user_id) {
        // Logged-in users → fetch from DB
        $sql = "SELECT
                c.id as cart_id,
                c.quantity,
                c.color,
                c.personalize_name,
                c.personalize_message,
                p.id AS product_id,
                p.pname,
                p.upc,
                p.pthumb
            FROM cart c
            JOIN product p ON c.product_id = p.id
            WHERE c.user_id = '$user_id'";
        $result = mysqli_query($mysqli, $sql);
        if ($result) {
            while ($row = mysqli_fetch_assoc($result)) {
                $products_to_checkout[] = $row;
                $grand_total += $row['quantity'] * $row['upc'];
            }
        }
    } else {
        // Guest → fetch from SESSION
        if (! empty($_SESSION['cart'])) {
            foreach ($_SESSION['cart'] as $index => $item) {
                $pid = $item['product_id'];
                $res = mysqli_query($mysqli, "SELECT pname, upc, pthumb FROM product WHERE id='$pid'");
                if ($prod = mysqli_fetch_assoc($res)) {
                    $products_to_checkout[] = [
                        'cart_id'             => $index,
                        'product_id'          => $pid,
                        'pname'               => $prod['pname'],
                        'upc'                 => $prod['upc'],
                        'pthumb'              => $prod['pthumb'],
                        'quantity'            => $item['quantity'],
                        'color'               => $item['color'] ?? '',
                        'personalize_name'    => $item['personalize_name'] ?? '',
                        'personalize_message' => $item['personalize_message'] ?? '',
                    ];
                    $grand_total += $prod['upc'] * $item['quantity'];
                }
            }
        }
    }
    // 🟢 Fetch logged-in user details
    $user = [];
    if ($user_id) {
        $sql = "SELECT *
            FROM users WHERE id = ?";
        $stmt = $mysqli->prepare($sql);
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $user   = $result->fetch_assoc();
    }

?>


<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
    <meta name="description" content="Mioca - Handmade Goods eCommerce HTML Template" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">
     <link href='https://fonts.googleapis.com/css?family=Delius+Swash+Caps' rel='stylesheet'>

</head>

<body>
    <header>
  <div class="header-main sticky-nav position-relative">
    <div class="container position-relative">
      <div class="d-flex align-items-center justify-content-between py-2">
        <!-- Logo -->
        <div class="header-logo">
          <a href="index.php">
            <img src="assets/images/logo/logo.png" alt="Site Logo" style="max-height: 90px;" />
          </a>
        </div>

        <!-- 3-dot toggle button -->
        <button class="mobile-menu-toggle d-lg-none border-0 bg-transparent fs-3">
          <i class="fa fa-bars" style="color: #e5097f;"></i>
        </button>

        <!-- Main Menu (Desktop) -->
        <nav class="main-menu d-none d-lg-block">
          <ul class="d-flex align-items-center gap-4 list-unstyled mb-0">
            <li><a href="index.php">Home</a></li>
            <li><a href="about.html">About</a></li>
            <li><a href="products.php">Products</a></li>
            <li class="dropdown position-static">
              <a href="#">Shop <i class="fa fa-angle-down"></i></a>
              <ul class="sub-menu">
                <li><a href="bags.php">Bags</a></li>
                <li><a href="cake_topper.php">Cake Topper</a></li>
                <li><a href="hair_clip.php">Hair Clips</a></li>
                <li><a href="home_decor.php">Home Decor</a></li>
                <li><a href="keychain.php">Keychain</a></li>
                <li><a href="nursary_decor.php">Nursary Decor</a></li>
                <li><a href="plant_hanging.php">Plant Hanging</a></li>
                <li><a href="rainbow.php">Rainbow</a></li>
              </ul>
            </li>
            <li><a href="contact.html">Contact</a></li>
          </ul>
        </nav>

        <!-- Header Actions (Desktop) -->
        <div class="header-actions d-none d-lg-flex align-items-center gap-3">
          <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
            <i class="pe-7s-search"></i>
          </a>
          <div class="dropdown">
            <button class="dropdown-toggle header-action-btn border-0 bg-transparent" data-bs-toggle="dropdown">
              <i class="pe-7s-users"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
              <li><a class="dropdown-item" href="my-account.php">My account</a></li>
              <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
              <li><a class="dropdown-item" href="login.html">Sign in</a></li>
            </ul>
          </div>
          <a href="wishlist.php" class="header-action-btn">
            <i class="pe-7s-like"></i>
            
          </a>
          <a href="my_cart.php" class="header-action-btn">
            <i class="pe-7s-shopbag"></i>
            
          </a>
        </div>
      </div>
    </div>

    <!-- Mobile Menu (Now appears just under header) -->
    <div class="mobile-menu d-lg-none">
      <ul class="list-unstyled m-0 p-3">
        <li><a href="index.php">Home</a></li>
        <li><a href="about.html">About</a></li>
        <li><a href="products.php">Products</a></li>
        <li class="dropdown">
          <a href="#">Shop</a>
          <ul class="sub-menu list-unstyled ms-3">
            <li><a href="bags.php">Bags</a></li>
            <li><a href="cake_topper.php">Cake Topper</a></li>
            <li><a href="hair_clip.php">Hair Clips</a></li>
            <li><a href="home_decor.php">Home Decor</a></li>
            <li><a href="keychain.php">Keychain</a></li>
            <li><a href="nursary_decor.php">Nursary Decor</a></li>
            <li><a href="plant_hanging.php">Plant Hanging</a></li>
            <li><a href="rainbow.php">Rainbow</a></li>
          </ul>
        </li>
        <li><a href="contact.html">Contact</a></li>
      </ul>
    </div>
  </div>
</header>

    <div class="offcanvas-overlay"></div>

    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">Checkout</h2>
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">Checkout</li>
                    </ul>
                    </div>
            </div>
        </div>
    </div>
    <form action="place_order.php" method="POST" id="checkoutForm">
        <div class="checkout-area pt-100px pb-100px">
            <div class="container">
                <div class="row">
                    <div class="col-lg-7">
                        <div class="billing-info-wrap">
                            <h3>Billing Details</h3>
                            <div class="row">
                                <div class="col-lg-12 col-md-6">
                                    <div class="billing-info mb-4">
                                        <label>Name</label>
                                        <input type="text" name="first_name"  value="<?php echo htmlspecialchars($user['fname'] ?? ''); ?>" required />
                                    </div>
                                </div>

                                <div class="col-lg-12">

                                </div>
                                <div class="col-lg-12">
                                    <div class="billing-info mb-4">
                                        <label>Street Address</label>
                                        <input class="billing-address" placeholder="House number and street name"
                                            type="text" name="address1"  value="<?php echo htmlspecialchars($user['address'] ?? ''); ?>"required />
                                        <input placeholder="Apartment, suite, unit etc." type="text" name="address2" />
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="billing-info mb-4">
                                        <label>Town / City</label>
                                        <input type="text" name="city"  value="<?php echo htmlspecialchars($user['city'] ?? ''); ?>" required />
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="billing-info mb-4">
                                        <label>State / Country</label>
                                        <input type="text" name="state_country"
                                            value="<?php echo htmlspecialchars(($user['state'] ?? '') . (! empty($user['country']) ? ', ' . $user['country'] : '')); ?>"
                                            required />
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6">
                                    <div class="billing-info mb-4">
                                        <label>Postcode / ZIP</label>
                                        <input type="text" name="zip"  value="<?php echo htmlspecialchars($user['zip'] ?? ''); ?>" required />
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="billing-info mb-4">
                                        <label>Phone</label>
                                        <input type="text" name="phone"  value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>"  required />
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6">
                                    <div class="billing-info mb-4">
                                        <label>Email Address</label>
                                        <input type="email" name="email"  value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" required />
                                    </div>
                                </div>
                            </div>

                            <div class="additional-info-wrap">
                                <h4>Additional information</h4>
                                <div class="additional-info">
                                    <label>Order notes</label>
                                    <textarea placeholder="Notes about your order..." name="order_notes"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-5 mt-md-30px mt-lm-30px ">
                        <div class="your-order-area">
                            <h3>Your order</h3>
                            <div class="your-order-product-info" style="border:1px solid #eee;border-radius:10px;overflow:hidden;font-family:Arial, sans-serif;">

                                <div class="your-order-top" style="background:#e5097f;padding:12px 15px;border-bottom:1px solid #eee; color:#fff;">
                                    <ul style="display:flex;justify-content:space-between;margin:0;padding:0;list-style:none;font-weight:bold;font-size:15px;">
                                        <li>Product</li>
                                        <li>Total</li>
                                    </ul>
                                </div>

                               <div class="your-order-middle" style="padding:12px 15px;">
    <ul style="list-style:none;margin:0;padding:0;">
        <?php
            // Loop through the fetched products to display them and create hidden inputs
            $grand_total = 0;
            foreach ($products_to_checkout as $product):
                $total_price = $product['upc'] * $product['quantity'];
                $grand_total += $total_price;
            ?>
														           <li style="display:flex;justify-content:space-between;align-items:center;padding:8px 0;border-bottom:1px dashed #ddd;">
														    <span class="order-middle-left" style="display:flex;flex-direction:column;gap:5px;font-size:14px;color:#333;">
														    <div style="display:flex;align-items:center;gap:10px;">
														        <a href="">
														            <img src="Admin/uploads/thumb/<?php echo $product['pthumb']; ?>"
														                 alt="<?php echo $product['pname']; ?>"
														                 style="width:45px;height:45px;object-fit:cover;border-radius:6px;border:1px solid #ddd;">
														        </a>
														        <?php echo $product['pname']; ?> × <b><?php echo $product['quantity']; ?></b>

														        <!-- Color -->
														        <?php if (! empty($product['color'])): ?>
														            <span style="display:flex;align-items:center;gap:5px;margin-left:10px;">
														                <span style="width:15px;height:15px;border-radius:50%;border:1px solid #ccc;display:inline-block;
														                             background-color:<?php echo htmlspecialchars($product['color']); ?>;">
														                </span>
														                <small style="color:#666;"><?php echo ucfirst($product['color']); ?></small>
														            </span>
														        <?php endif; ?>
    </div>

                                    <!-- Personalization -->
                                    <?php if (! empty($product['personalize_name']) || ! empty($product['personalize_message'])): ?>
                                        <div style="font-size:13px;color:#666;margin-top:4px;">
                                            <?php if (! empty($product['personalize_name'])): ?>
                                                <div><strong>Name:</strong><?php echo htmlspecialchars($product['personalize_name']); ?></div>
                                            <?php endif; ?>
                                <?php if (! empty($product['personalize_message'])): ?>
                                                <div><strong>Message:</strong><?php echo htmlspecialchars($product['personalize_message']); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </span>

                                    <span class="order-price" style="font-weight:600;color:#111;">
                                        $<?php echo number_format($total_price, 2); ?>
                                    </span>
                                </li>


                                            <!-- ✅ Hidden inputs -->
                                        <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][id]" value="<?php echo $product['product_id']; ?>">
                                    <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][name]" value="<?php echo htmlspecialchars($product['pname']); ?>">
                                    <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][quantity]" value="<?php echo $product['quantity']; ?>">
                                    <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][price]" value="<?php echo $product['upc']; ?>">
                                    <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][color]" value="<?php echo htmlspecialchars($product['color']); ?>">
                                    <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][personalize_name]" value="<?php echo htmlspecialchars($product['personalize_name']); ?>">
                                    <input type="hidden" name="products[<?php echo $product['cart_id']; ?>][personalize_message]" value="<?php echo htmlspecialchars($product['personalize_message']); ?>">


                                        <?php endforeach; ?>
                                    </ul>
                                </div>


                                <div class="your-order-bottom" style="padding:12px 15px;border-top:1px #eee;">
                                    <ul style="display:flex;justify-content:space-between;list-style:none;margin:0;padding:0;font-size:14px;">
                                        <li class="your-order-shipping" style="color:#555;">Shipping</li>
                                        <li style="font-weight:600;color:#28a745;">Free Shipping</li>
                                    </ul>
                                </div>

                                <div class="your-order-total" style="padding:15px;background:#e5097f;border-top:1px solid #ddd;">
                                    <ul style="display:flex;justify-content:space-between;list-style:none;margin:0;padding:0;font-size:16px;font-weight:bold; color: #fff;">
                                        <li class="order-total">Grand Total</li>
                                        <li style="color:#fff;">$<?php echo number_format($grand_total, 2); ?></li>
                                    </ul>
                                </div>
                                <input type="hidden" name="grand_total" value="<?php echo $grand_total; ?>">
                            </div>

                            <div class="payment-method">
                                <div class="payment-accordion element-mrg">
                                    <div id="faq" class="panel-group">
                                        <div class="panel panel-default single-my-account m-0">
                                            <div class="panel-heading my-account-title">
                                                <h4 class="panel-title"><a data-bs-toggle="collapse"
                                                        href="#my-account-3">Cash on delivery</a></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="Place-order mt-25">
                              <a href="#" class="btn-hover"
                                onclick="if(document.getElementById('checkoutForm').reportValidity()){ document.getElementById('checkoutForm').submit(); }">
                                Place Order
                                </a>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
     <!-- Footer Area Start -->
        <div class="footer-area">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="row">
                            <!-- Start single blog -->
                            <div class="col-md-8 col-sm-6 col-lg-4 mb-md-30px mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Craftsy Angel</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            Macrame, crafted by the skilled hands <br>of the artisans at Craftsy Angel,<br> is a true testament to the beauty of hand-made creations.
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Account</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li" ><a class="single-link" style="color: #fff;" href="about.html">About us</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="contact.html">Contact Us</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="return_policy.php">Return Policy</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="refund_policy.php">Refund Policy</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-sm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Shop </h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" style="color: #fff;" href="bags.php">Bags</a></li>
                                                <li class="li"><a class="single-link"style="color: #fff;" href="cake_topper.php">Cake Topper</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="hair_clip.php">Hair Clips</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="home_decor.php">Home Decor</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-4 col-lg-4 col-md-6 col-sm-6 pl-120px line-shape">
                                <div class="single-wedge ">

                                    <h4 class="footer-herading">Contact Us</h4>
                                    <div class="footer-links">

                                       <p><i class="fa fa-whatsapp" style="color:#fff; font-size:22px; margin-right:10px;"></i><span><a class="single-link" href="tel:+91 98253 42222">+91 98253 42222</a></p>
                                        <p><i class="fa fa-envelope" style="color:#fff; font-size:22px; margin-right:10px;"></i><span><a class="single-link" href="mailto:info@craftsyangel.com">info@craftsyangel.com</a></span></p>
                                      <p> <i class="fa fa-instagram" style="color:#fff; font-size:22px; margin-right:10px;"></i><span style="color: White;"><a class="single-link" href="https://www.instagram.com/craftsyangel" target="_blank" >craftsyangel</a></span></p>

                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            
                            <!-- End single blog -->
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="line-shape-top">
                            <div class="row flex-md-row-reverse align-items-center">
                                <div class="col-md-6 text-center text-md-end">

                                </div>
                                <div class="col-md-6 text-center text-md-start">
                                    <p class="copy-text"> © 2025 <strong>Craftsy Angel</strong> | All Rights Received.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer Area End -->
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>

    <script src="assets/js/main.js"></script>

</body>

</html>