<?php
session_start();
include 'dbconn.php';

// Check if the user is logged in
if (! isset($_SESSION['user_id'])) {
    header("Location: login.html");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: checkout.php");
    exit;
}

$user_id     = $_SESSION['user_id'];
$first_name  = mysqli_real_escape_string($mysqli, $_POST['first_name']);
$address1    = mysqli_real_escape_string($mysqli, $_POST['address1']);
$address2    = mysqli_real_escape_string($mysqli, $_POST['address2']);
$city        = mysqli_real_escape_string($mysqli, $_POST['city']);
$state       = mysqli_real_escape_string($mysqli, $_POST['state']);
$zip         = mysqli_real_escape_string($mysqli, $_POST['zip']);
$phone       = mysqli_real_escape_string($mysqli, $_POST['phone']);
$email       = mysqli_real_escape_string($mysqli, $_POST['email']);
$order_notes = mysqli_real_escape_string($mysqli, $_POST['order_notes']);
$grand_total = floatval($_POST['grand_total']);
$products    = $_POST['products'];

mysqli_begin_transaction($mysqli);

try {
    // Insert into orders
    $insert_order_sql = "INSERT INTO orders
        (user_id, first_name, email, phone, address1, address2, city, state, zip, order_notes, grand_total, order_date)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
    $stmt = mysqli_prepare($mysqli, $insert_order_sql);
    mysqli_stmt_bind_param($stmt, "isssssssssd", $user_id, $first_name, $email, $phone, $address1, $address2, $city, $state, $zip, $order_notes, $grand_total);
    mysqli_stmt_execute($stmt);
    $order_id = mysqli_insert_id($mysqli);
    mysqli_stmt_close($stmt);

    // Insert products
    $insert_item_sql = "INSERT INTO order_items
        (order_id, product_id, quantity, price, total, color, personalize_name, personalize_message)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt_item = mysqli_prepare($mysqli, $insert_item_sql);

    $order_items_html = ""; // build email table rows

    foreach ($products as $product) {
        $product_id          = intval($product['id']);
        $quantity            = intval($product['quantity']);
        $price               = floatval($product['price']);
        $color               = mysqli_real_escape_string($mysqli, $product['color']);
        $personalize_name    = mysqli_real_escape_string($mysqli, $product['personalize_name']);
        $personalize_message = mysqli_real_escape_string($mysqli, $product['personalize_message']);
        $total               = $quantity * $price;

        mysqli_stmt_bind_param($stmt_item, "iiiddsss", $order_id, $product_id, $quantity, $price, $total, $color, $personalize_name, $personalize_message);
        mysqli_stmt_execute($stmt_item);

        // Fetch product name & image (from your products table)
        $presult = mysqli_query($mysqli, "SELECT pname, pthumb FROM product WHERE id = $product_id");
        $prow    = mysqli_fetch_assoc($presult);

        $order_items_html .= "
        <tr>
            <td style='padding:10px; border:1px solid #ddd; text-align:center;'>
               <img src='https://bhavik.kitret.com/craftsy-angel/Admin/uploads/thumb/" . $prow['pthumb'] . "' width='60'>
            </td>
            <td style='padding:10px; border:1px solid #ddd;'>" . $prow['pname'] . "</td>
            <td style='padding:10px; border:1px solid #ddd; text-align:center;'>" . $quantity . "</td>
            <td style='padding:10px; border:1px solid #ddd; text-align:right;'>₹" . $total . "</td>
        </tr>";
    }
    mysqli_stmt_close($stmt_item);

    // Clear cart
    $stmt_clear = mysqli_prepare($mysqli, "DELETE FROM cart WHERE user_id = ?");
    mysqli_stmt_bind_param($stmt_clear, "i", $user_id);
    mysqli_stmt_execute($stmt_clear);
    mysqli_stmt_close($stmt_clear);

    mysqli_commit($mysqli);

    /** ---------------- SEND ORDER SUCCESS EMAIL ----------------- **/
    $subject = "Your Order #$order_id has been placed successfully!";
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: info@bhavik.kitret.com" . "\r\n";

// Use your uploaded template + logo
    $message = "
<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <title>Order Success</title>
</head>
<body style='margin:0;padding:0;background-color:#FAFAFA;font-family:Arial,sans-serif;'>
  <div style='background-color:#FAFAFA;padding:20px 0;'>
    <table align='center' width='600' cellpadding='0' cellspacing='0' style='background:#fff;border:1px solid #e06666;border-radius:8px;overflow:hidden;'>

      <!-- ✅ Logo Section -->
      <tr>
        <td align='center' style='padding:20px;'>
          <img src='https://fjldusj.stripocdn.email/content/guids/CABINET_16e121cdd3958cc292dbd12ff9305248140210590ab6a793520a0bdc45bd7bb7/images/logo.png'
               alt='CrafsyAngel Logo' width='150' height='80' style='display:block;margin:0 auto;'>
        </td>
      </tr>

      <!-- ✅ Success Header -->
      <tr>
        <td align='center' style='padding:20px;background:#28a745;color:#fff;font-size:20px;font-weight:bold;'>
          ✅ Your order has been placed successfully!
        </td>
      </tr>


      <!-- ✅ Content -->
      <tr>
        <td style='padding:20px;color:#333;font-size:14px;line-height:1.6;'>
          <p>Dear <b>$first_name $last_name</b>,</p>
          <p>Thank you for your order! Your order ID is <b>#$order_id</b>.</p>
          <p><b>Order Details:</b></p>
          <table width='100%' cellspacing='0' cellpadding='0' style='border-collapse:collapse;margin-top:10px;'>
            <tr style='background:#f8f8f8;'>
              <th style='padding:10px;border:1px solid #ddd;'>Image</th>
              <th style='padding:10px;border:1px solid #ddd;'>Product</th>
              <th style='padding:10px;border:1px solid #ddd;'>Qty</th>
              <th style='padding:10px;border:1px solid #ddd;'>Total</th>
            </tr>
            $order_items_html
            <tr>
              <td colspan='3' style='padding:10px;text-align:right;font-weight:bold;border:1px solid #ddd;'>Grand Total</td>
              <td style='padding:10px;text-align:right;border:1px solid #ddd;'><b>₹$grand_total</b></td>
            </tr>
          </table>
          <p style='margin-top:20px;'>We will notify you once your order is shipped.</p>
          <div style='margin-top:20px;text-align:center;'>
            <a href='https://bhavik.kitret.com/craftsy-angel/'
               style='background:#ef1386;color:#fff;text-decoration:none;padding:12px 25px;border-radius:6px;font-size:16px;'>
              Keep Shopping
            </a>
          </div>
        </td>
      </tr>

      <!-- ✅ Footer -->
      <tr>
        <td style='background:#f1f1f1;padding:10px;text-align:center;font-size:12px;color:#555;'>
          © " . date("Y") . " CrafsyAngel. All rights reserved.
        </td>
      </tr>
    </table>
  </div>

</body>
</html>
";

    mail($email, $subject, $message, $headers);

    // Redirect
    header("Location: my-account.php?order_id=" . $order_id . "&status=success");
    exit;

} catch (mysqli_sql_exception $e) {
    mysqli_rollback($mysqli);
    error_log("Order placement failed: " . $e->getMessage());
    header("Location: checkout.php?error=order_failed");
    exit;
}
