<?php
session_start();
require 'dbconn.php'; // DB connection

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['user-name'] ?? '');
    $fname    = trim($_POST['user-fname'] ?? '');
    $password = trim($_POST['user-password'] ?? '');
    $email    = trim($_POST['user-email'] ?? '');
    $phone    = trim($_POST['user-phone'] ?? '');

    // Validation
    if (empty($username) || empty($password) || empty($email)) {
        echo "<script>alert('All fields are required!'); window.history.back();</script>";
        exit;
    }
    if (! filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "<script>alert('Invalid email format!'); window.history.back();</script>";
        exit;
    }

    // Check if email exists
    $stmt = $mysqli->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        echo "<script>alert('Email already registered!'); window.history.back();</script>";
        exit;
    }
    $stmt->close();

    // Hash password (MD5)
    $hashedPassword = md5($password);

    // Insert user
    $stmt = $mysqli->prepare("INSERT INTO users (username, fname , password, email, phone) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sssss", $username, $fname, $hashedPassword, $email, $phone);

    if ($stmt->execute()) {

        // ✅ Send registration email
        $to      = $email;
        $subject = "Welcome to Our Website - Registration Successful";

        $message = "
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin:0; padding:0; }
                .container { max-width: 500px; margin: 30px auto; background: #fff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1);}
                .header { background: #f44336; padding: 30px; text-align: center; color: #fff; }
                .header .checkmark { font-size: 50px; }
                .content { padding: 20px; text-align: center; }
                .content h2 { color: #333; margin-bottom: 10px; }
                .content p { color: #666; font-size: 14px; line-height: 1.6; }
                .btn { display: inline-block; margin-top: 20px; padding: 12px 20px; background: #f44336; color: #fff; text-decoration: none; border-radius: 5px; font-weight: bold;}
                .btn:hover { background: #d32f2f; }
                .footer { margin-top: 20px; font-size: 12px; color: #999; text-align: center; padding: 10px;}
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <div class='checkmark'>✔</div>
                </div>
                <div class='content'>
                    <h2>Thank you for your registration, $fname!</h2>
                    <p>Welcome aboard, <strong>$username</strong>. Your account has been created successfully.</p>
                    // <a href='http://yourwebsite.com/login.html' class='btn'>Complete your registration</a>
                    <p style='margin-top:10px;'>or <a href='http://yourwebsite.com/login.html'>log in</a> to your account.</p>
                </div>
                <div class='footer'>
                    &copy; " . date("Y") . " Your Company Name. All rights reserved.
                </div>
            </div>

</body>
        </html>";

        // Headers
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: Your Company <no-reply@yourwebsite.com>" . "\r\n";

        // Send email
        mail($to, $subject, $message, $headers);

        echo "<script>alert('Registration successful! Confirmation email sent.'); window.location.href='login.html';</script>";
    } else {
        echo "<script>alert('Error: " . addslashes($mysqli->error) . "'); window.history.back();</script>";
    }

    $stmt->close();
    $mysqli->close();
}
