<?php
session_start();
require 'dbconn.php'; // DB connection

// Ensure user is logged in
if (! isset($_SESSION['user_id'])) {
    header("Location: login.html");
    exit;
}

$user_id = $_SESSION['user_id'];

// Get form data safely
$id_gender = isset($_POST['id_gender']) ? (int) $_POST['id_gender'] : 0;
$username  = trim($_POST['first-name'] ?? '');
$phone     = trim($_POST['last-name'] ?? '');
$email     = trim($_POST['email-name'] ?? '');
$birthday  = trim($_POST['birthday'] ?? '');

// Validation
$errors = [];

if ($id_gender < 1 || $id_gender > 2) {
    $errors[] = "Invalid gender selected.";
}

if (empty($username)) {
    $errors[] = "Name is required.";
}

if (! empty($email) && ! filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $errors[] = "Invalid email format.";
}

// Convert birthday
if (! empty($birthday)) {
    $birthday = date('Y-m-d', strtotime($birthday));
} else {
    $birthday = null;
}

if (empty($errors)) {
    $sql = "UPDATE users
            SET gender = ?, fname = ?, phone = ?, email = ?, birthday = ?
            WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("issssi", $id_gender, $username, $phone, $email, $birthday, $user_id);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Account updated successfully.";

        // ✅ Send Fancy Confirmation Email
        $to      = $email;
        $subject = "Profile Updated Successfully - CrafsyAngel";

        $message = "
        <!DOCTYPE html>
        <html lang='en'>
        <head>
            <meta charset='UTF-8'>
            <title>Profile Updated</title>
        </head>
        <body style='background-color:#FAFAFA; font-family:Arial, Helvetica, sans-serif; margin:0; padding:0;'>
            <table width='100%' cellpadding='0' cellspacing='0' style='background-color:#FAFAFA; padding:20px 0;'>
                <tr>
                    <td align='center'>
                        <table width='600' cellpadding='0' cellspacing='0' style='background:#ffffff; border:1px solid #e06666;'>
                            <!-- Header -->
                            <tr>
                                <td align='center' style='padding:20px; border-bottom:1px solid #e06666;'>
                                    <img src='https://fjldusj.stripocdn.email/content/guids/CABINET_16e121cdd3958cc292dbd12ff9305248140210590ab6a793520a0bdc45bd7bb7/images/logo.png' width='150' alt='Logo' style='display:block; margin:0 auto;'>
                                </td>
                            </tr>
                            <!-- Main Content -->
                            <tr>
                                <td align='center' style='padding:30px;'>
                                    <h2 style='color:#38761d; background:#d9ead3; padding:10px; display:inline-block;'>✔ Profile Updated Successfully!</h2>
                                    <p style='font-size:14px; color:#333; margin-top:20px;'>Hello <strong style='color:#a64d79;'>$username</strong>,</p>
                                    <p style='font-size:14px; color:#333; line-height:1.6;'>Your profile details have been successfully updated at <strong>CrafsyAngel</strong>.</p>
                                    <a href='http://yourwebsite.com/my-account.php' target='_blank' style='display:inline-block; margin-top:20px; padding:12px 30px; background:#c27ba0; color:#fff; text-decoration:none; border-radius:6px; font-size:16px;'>View My Account</a>
                                </td>
                            </tr>
                            <!-- Footer -->
                            <tr>
                                <td align='center' style='padding:15px; background:#fafafa; font-size:12px; color:#666; border-top:1px solid #e06666;'>
                                    &copy; " . date("Y") . " CrafsyAngel. All rights reserved.
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

</body>
        </html>";

        // Headers
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8\r\n";
        $headers .= "From: info@bhavik.kitret.com\r\n";

        // Send email
        mail($to, $subject, $message, $headers);

    } else {
        $_SESSION['error_msg'] = "Error updating account: " . $stmt->error;
    }

    header("Location: my-account.php");
    exit;
} else {
    $_SESSION['error_msg'] = implode('<br>', $errors);
    header("Location: my-account.php");
    exit;
}
