<?php
include 'dbconn.php';
session_start();
header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Invalid request.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cart_id']) && isset($_POST['quantity'])) {
    $cart_id      = intval($_POST['cart_id']);
    $new_quantity = intval($_POST['quantity']);

    // Ensure quantity is at least 1
    if ($new_quantity < 1) {
        $new_quantity = 1;
    }

    $is_logged_in  = isset($_SESSION['user_id']);
    $grand_total   = 0;
    $item_subtotal = 0;

    if ($is_logged_in) {
        $user_id = $_SESSION['user_id'];

        // Update quantity in database
        $update_sql = "UPDATE cart SET quantity = $new_quantity WHERE id = $cart_id AND user_id = $user_id";
        if (mysqli_query($mysqli, $update_sql)) {
            // Fetch updated item subtotal
            $item_sql = "SELECT p.upc, c.quantity
                         FROM cart c
                         JOIN product p ON c.product_id = p.id
                         WHERE c.id = $cart_id";
            $item_result   = mysqli_query($mysqli, $item_sql);
            $item_row      = mysqli_fetch_assoc($item_result);
            $item_subtotal = $item_row['upc'] * $item_row['quantity'];

            // Recalculate grand total
            $grand_total_sql = "SELECT SUM(p.upc * c.quantity) AS grand_total
                                FROM cart c
                                JOIN product p ON c.product_id = p.id
                                WHERE c.user_id = $user_id";
            $grand_total_result = mysqli_query($mysqli, $grand_total_sql);
            $grand_total_row    = mysqli_fetch_assoc($grand_total_result);
            $grand_total        = $grand_total_row['grand_total'];

            $response['status']        = 'success';
            $response['item_subtotal'] = $item_subtotal;
            $response['grand_total']   = $grand_total;
        } else {
            $response['message'] = "DB Error: " . mysqli_error($mysqli);
        }

    } else {
        // Guest user → update $_SESSION['cart']
        if (isset($_SESSION['cart'][$cart_id])) {
            $_SESSION['cart'][$cart_id]['quantity'] = $new_quantity;

            // Calculate item subtotal
            $product_id    = $_SESSION['cart'][$cart_id]['product_id'];
            $res           = mysqli_query($mysqli, "SELECT upc FROM product WHERE id = $product_id");
            $prod          = mysqli_fetch_assoc($res);
            $item_subtotal = $prod['upc'] * $new_quantity;

            // Recalculate grand total
            foreach ($_SESSION['cart'] as $c_item) {
                $res2 = mysqli_query($mysqli, "SELECT upc FROM product WHERE id = {$c_item['product_id']}");
                $p    = mysqli_fetch_assoc($res2);
                $grand_total += $p['upc'] * $c_item['quantity'];
            }

            $response['status']        = 'success';
            $response['item_subtotal'] = $item_subtotal;
            $response['grand_total']   = $grand_total;
        } else {
            $response['message'] = "Cart item not found in session.";
        }
    }
}

echo json_encode($response);
exit;
