<?php 
include('contctn.php'); 
include('session-chk.php'); 
$pimgpath = "uploads/product"; // ✅ define path for image usage
require_once('ckeditor/ckeditor_php5.php');  

// Get product details
if (isset($_GET['edt'])) {
    $id = (int)$_GET['edt'];
    $q = "SELECT * FROM product WHERE id = $id";
    $fire = mysqli_query($db, $q);
    $re = mysqli_fetch_assoc($fire);
}
?>

<!doctype html>
<html class="fixed">
<head>
    <meta charset="UTF-8">
    <title>Edit Product</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet">
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.css" />
    <link rel="stylesheet" href="vendor/animate/animate.css">
    <link rel="stylesheet" href="vendor/font-awesome/css/all.min.css" />
    <link rel="stylesheet" href="vendor/bootstrap-fileupload/bootstrap-fileupload.min.css" />
    <link rel="stylesheet" href="css/theme.css" />
    <link rel="stylesheet" href="css/custom.css">
    <script src="ckeditor/ckeditor.js"></script>
</head>
<body>
<section class="body">
    <?php include('header.php'); ?>
    <div class="inner-wrapper">
        <?php include('sidemenu.php'); ?>
        <section role="main" class="content-body card-margin">
            <header class="page-header">
                <h2>Edit Product</h2>
            </header>
            <div class="row">
                <div class="col">
                    <section class="card">
                        <form class="form-horizontal form-bordered" method="post" enctype="multipart/form-data">
                            <header class="card-header">
                                <h2 class="card-title">Product Details</h2>
                            </header>
                            <div class="card-body">
                                <!-- Product Name -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Product Name</label>
                                    <div class="col-lg-6">
                                        <input type="text" name="pname" value="<?= htmlspecialchars($re['pname']) ?>" class="form-control" required>
                                    </div>
                                </div>
                                <!-- Price -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Price</label>
                                    <div class="col-lg-6">
                                        <input type="text" name="upc" value="<?= htmlspecialchars($re['upc']) ?>" class="form-control" required>
                                    </div>
                                </div>
                                <!-- Category -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Select Category</label>
                                    <div class="col-lg-6">
                                        <select class="form-control mb-3" name="catid" required id="category">
                                            <option value="">Select Category</option>
                                            <?php 
                                            $ew = mysqli_query($db,"SELECT * from category");
                                            while($row = mysqli_fetch_assoc($ew)) {
                                                $sel = ($row['id'] == $re['catid']) ? "selected" : "";
                                                echo "<option value='{$row['id']}' $sel>{$row['category']}</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <!-- Subcategory -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Select Sub Category</label>
                                    <div class="col-lg-6">
                                        <select class="form-control mb-3" name="subcatid" id="sub_category">
                                            <?php 
                                            if ($re['subcatid']) {
                                                $sub = mysqli_query($db,"SELECT * from subcategory WHERE id=".$re['subcatid']);
                                                if ($subr = mysqli_fetch_assoc($sub)) {
                                                    echo "<option value='{$subr['id']}' selected>{$subr['subcategory']}</option>";
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                </div>
                                <!-- Short Description -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Short Description</label>
                                    <div class="col-lg-10">
                                        <textarea name="sdesc" required><?= $re['sdesc'] ?></textarea>
                                        <script>CKEDITOR.replace('sdesc');</script>
                                    </div>
                                </div>
                                <!-- Long Description -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Long Description</label>
                                    <div class="col-lg-10">
                                        <textarea name="ldesc" required><?= $re['ldesc'] ?></textarea>
                                        <script>CKEDITOR.replace('ldesc');</script>
                                    </div>
                                </div>
                                <!-- Images -->
                                <?php 
                                $images = [
                                    'pthumb' => 'Product Thumbnail',
                                    'pimage' => 'Product Image (1)',
                                    'pimage2' => 'Product Image (2)',
                                    'pimage3' => 'Product Image (3)',
                                    'pimage4' => 'Product Image (4)',
                                    'pimage5' => 'Product Image (5)'
                                ];
                                foreach ($images as $field => $label) { 
                                    $folder = ($field == 'pthumb') ? 'uploads/thumb/' : 'uploads/product/';
                                    $imgPath = ($re[$field]) ? $folder.$re[$field] : 'items/noimage.jpg';
                                ?>
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2"><?= $label ?></label>
                                    <div class="col-lg-6">
                                        <input type="file" name="<?= $field ?>">
                                        <br><img src="<?= $imgPath ?>" style="width:80px;margin-top:5px;">
                                    </div>
                                </div>
                                <?php } ?>
                                <!-- Quantity -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Quantity</label>
                                    <div class="col-lg-6">
                                        <input type="number" name="quantity" value="<?= $re['quantity'] ?>" class="form-control" min="1" required>
                                    </div>
                                </div>
                                <!-- Availability -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Availability</label>
                                    <div class="col-lg-6">
                                        <select name="availability" class="form-control" required>
                                            <option value="Yes" <?= ($re['availability']=='Yes')?'selected':'' ?>>Yes</option>
                                            <option value="No" <?= ($re['availability']=='No')?'selected':'' ?>>No</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Delivery Time -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Time to Deliver</label>
                                    <div class="col-lg-6">
                                        <input type="text" name="delivery_time" value="<?= $re['delivery_time'] ?>" class="form-control" required>
                                    </div>
                                </div>
                                <!-- Colors -->
                                <div class="form-group row" id="color-field-group">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Colors</label>
                                    <div class="col-lg-6">
                                        <?php 
                                        $colorList = explode(',', $re['colors']);
                                        foreach ($colorList as $i => $color) { ?>
                                            <div class="input-group mb-2">
                                                <input type="text" name="colors[]" value="<?= $color ?>" class="form-control" required>
                                                <div class="input-group-append">
                                                    <?php if($i==0){ ?>
                                                        <button type="button" class="btn btn-success add-color">+</button>
                                                    <?php } else { ?>
                                                        <button type="button" class="btn btn-danger remove-color">-</button>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                                <!-- Status -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Status</label>
                                    <div class="col-lg-6">
                                        <select class="form-control" name="status" required>
                                            <option value="1" <?= ($re['status']==1)?'selected':'' ?>>Enable</option>
                                            <option value="0" <?= ($re['status']==0)?'selected':'' ?>>Disable</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <footer class="card-footer text-right">
                                <button class="btn btn-primary" type="submit" name="sbtt">Update</button>
                            </footer>
                        </form>
                    </section>
                </div>
            </div>
        </section>
    </div>
</section>

<script src="vendor/jquery/jquery.js"></script>
<script>
$('#category').on('change', function() {
    var category_id = this.value;
    $.post("pget.php", {category_id: category_id}, function(data){
        $("#sub_category").html(data);
    });
});

document.addEventListener('click', function(e) {
    if (e.target.classList.contains('add-color')) {
        const container = document.querySelector('#color-field-group .col-lg-6');
        const inputGroup = document.createElement('div');
        inputGroup.className = 'input-group mb-2';
        inputGroup.innerHTML = `
            <input type="text" name="colors[]" class="form-control" placeholder="Enter color" required>
            <div class="input-group-append">
                <button type="button" class="btn btn-danger remove-color">-</button>
            </div>`;
        container.appendChild(inputGroup);
    }
    if (e.target.classList.contains('remove-color')) {
        e.target.closest('.input-group').remove();
    }
});
</script>
</body>
</html>

<?php 
if(isset($_POST['sbtt'])){
    function uploadImage($inputName, $targetDir, $oldFile) {
        if(!empty($_FILES[$inputName]['name'])) {
            $filename = basename($_FILES[$inputName]["name"]);
            move_uploaded_file($_FILES[$inputName]["tmp_name"], $targetDir . $filename);
            return $filename;
        }
        return $oldFile; // keep old if not replaced
    }
    $prname = mysqli_real_escape_string($db, $_POST['pname']);
    $upc = mysqli_real_escape_string($db, $_POST['upc']);
    $cid = (int)$_POST['catid'];
    $subid = ($_POST['subcatid']!='') ? (int)$_POST['subcatid'] : NULL;
    $sdesc = mysqli_real_escape_string($db, $_POST['sdesc']);
    $ldesc = mysqli_real_escape_string($db, $_POST['ldesc']);
    $status = (int)$_POST['status'];
    $quantity = (int)$_POST['quantity'];
    $availability = mysqli_real_escape_string($db, $_POST['availability']);
    $delivery_time = mysqli_real_escape_string($db, $_POST['delivery_time']);
    $colors = implode(',', array_map(function($c) use ($db) {
        return mysqli_real_escape_string($db, $c);
    }, $_POST['colors']));

    $pthumb = uploadImage('pthumb', "uploads/thumb/", $re['pthumb']);
    $pimg   = uploadImage('pimage', "uploads/product/", $re['pimage']);
    $pimg2  = uploadImage('pimage2', "uploads/product/", $re['pimage2']);
    $pimg3  = uploadImage('pimage3', "uploads/product/", $re['pimage3']);
    $pimg4  = uploadImage('pimage4', "uploads/product/", $re['pimage4']);
    $pimg5  = uploadImage('pimage5', "uploads/product/", $re['pimage5']);

    $sql = "UPDATE product SET 
        catid='$cid', 
        subcatid=" . ($subid ? "'$subid'" : "NULL") . ", 
        pname='$prname', 
        upc='$upc', 
        sdesc='$sdesc', 
        ldesc='$ldesc',
        pthumb='$pthumb',
        pimage='$pimg',
        pimage2='$pimg2',
        pimage3='$pimg3',
        pimage4='$pimg4',
        pimage5='$pimg5',
        quantity='$quantity',
        availability='$availability',
        delivery_time='$delivery_time',
        colors='$colors',
        status='$status'
        WHERE id='$id'";

    if (mysqli_query($db, $sql)) {
        echo "<script>alert('Product Updated Successfully');window.location='manage-product.php';</script>";
    } else {
        echo "Error: " . mysqli_error($db);
    }
}
?>
