<?php
    include 'contctn.php';
    include 'session-chk.php';

    // Check if the database connection is successful
    if ($db->connect_error) {
        die("Connection failed: " . $db->connect_error);
    }

    // Prepare the SQL statement to get the total number of sessions
    $sql  = "SELECT COUNT(*) as total FROM user_sessions";
    $stmt = $db->prepare($sql);

    $totalUsers = "Error"; // Default value in case of an error
    if ($stmt) {
        // Execute the prepared statement
        $stmt->execute();

        // Get the result
        $result     = $stmt->get_result();
        $row        = $result->fetch_assoc();
        $totalUsers = $row['total'];

        // Close the statement
        $stmt->close();
    }

    // Close the database connection
    $db->close();
?>
<!doctype html>
<html class="fixed">
<head>
    <meta charset="UTF-8">
    <title>Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.css" />
    <link rel="stylesheet" href="vendor/animate/animate.css">
    <link rel="stylesheet" href="vendor/font-awesome/css/all.min.css" />
    <link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.css" />
    <link rel="stylesheet" href="vendor/bootstrap-datepicker/css/bootstrap-datepicker3.css" />
    <link rel="stylesheet" href="vendor/bootstrap-fileupload/bootstrap-fileupload.min.css" />
    <link rel="stylesheet" href="css/theme.css" />
    <link rel="stylesheet" href="css/skins/default.css" />
    <link rel="stylesheet" href="css/custom.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="vendor/modernizr/modernizr.js"></script>
    <style>
        /* Custom CSS for the Visitors Card */
        .visitor-card {
            transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
            border: none;
        }
        .visitor-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15) !important;
        }
        .visitor-card .card-body {
            background-color: #ffffff;
            border-radius: 0.75rem;
            padding: 2.5rem;
        }
        .visitor-card .card-title {
            font-weight: 500;
            letter-spacing: 1px;
            color: #6c757d !important;
            text-transform: uppercase;
        }
        .visitor-card .display-5 {
            font-size: 3.5rem;
            font-weight: 700 !important;
            color: #212529 !important;
        }
        .bi-people-fill {
            color: #0d6efd !important;
            font-size: 4rem;
            transition: color 0.3s ease-in-out;
        }
        .visitor-card:hover .bi-people-fill {
            color: #0a58ca !important;
        }
    </style>
</head>
<body>
    <section class="body">
        <?php include 'header.php'; ?>
        <div class="inner-wrapper">
            <?php include 'sidemenu.php'; ?>
            <section role="main" class="content-body card-margin">
                <header class="page-header">
                    <h2>Dashboard</h2>
                </header>
                <div class="row justify-content-center">
                    <div class="col-md-5 col-lg-4">
                        <section class="card visitor-card shadow-lg rounded-4">
                            <div class="card-body text-center">
                                <div class="mb-4">
                                    <i class="bi bi-people-fill"></i>
                                </div>
                                <h5 class="card-title">Total Visitors</h5>
                                <h2 class="display-5">
                                    <?php echo htmlspecialchars($totalUsers); ?>
                                </h2>
                                <!-- <p class="text-secondary mb-0">All time recorded sessions</p> -->
                            </div>
                        </section>
                    </div>
                </div>
                </section>
        </div>
    </section>
<script>
    setTimeout(function(){
        location.reload();
    }, 2000); // 2000 ms = 2 seconds
</script>

    <script src="vendor/jquery/jquery.js"></script>
    <script src="vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
    <script src="vendor/popper/umd/popper.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.js"></script>
    <script src="vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="vendor/common/common.js"></script>
    <script src="vendor/nanoscroller/nanoscroller.js"></script>
    <script src="vendor/magnific-popup/jquery.magnific-popup.js"></script>
    <script src="vendor/jquery-placeholder/jquery.placeholder.js"></script>
    <script src="vendor/autosize/autosize.js"></script>
    <script src="vendor/bootstrap-fileupload/bootstrap-fileupload.min.js"></script>
    <script src="js/theme.js"></script>
    <script src="js/custom.js"></script>
    <script src="js/theme.init.js"></script>
</body>
</html>