<?php 
include('contctn.php'); 
include('session-chk.php'); 

$pimgpath = "uploads/product"; // ✅ Define this to use in image paths
$pthumbpath = "uploads/thumb"; // ✅ Define this to use in image paths

if(isset($_GET['view'])) {
    $id = $_GET['view'];

    $q = "SELECT * FROM product 
          INNER JOIN category ON product.catid = category.id 
          WHERE product.id = $id";

    $fire = mysqli_query($db, $q);
    $re = mysqli_fetch_assoc($fire);
}
?>


<!doctype html>
<html class="fixed">
	<head>
		<meta charset="UTF-8">
		<title>View Product Details</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800|Shadows+Into+Light" rel="stylesheet" type="text/css">
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.css" />
		<link rel="stylesheet" href="vendor/animate/animate.css">
		<link rel="stylesheet" href="vendor/font-awesome/css/all.min.css" />
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.css" />
		<link rel="stylesheet" href="vendor/bootstrap-datepicker/css/bootstrap-datepicker3.css" />
		<link rel="stylesheet" href="vendor/bootstrap-fileupload/bootstrap-fileupload.min.css" />
		<link rel="stylesheet" href="css/theme.css" />
		<link rel="stylesheet" href="css/skins/default.css" />
		<link rel="stylesheet" href="css/custom.css">
		<script src="vendor/modernizr/modernizr.js"></script>
		<script src="https://cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>

	</head>
	<body>
		<section class="body">
			<!-- start: header -->
			<?php include('header.php'); ?>
			<!-- end: header -->

			<div class="inner-wrapper">
				<!-- start: sidebar -->
				<?php include('sidemenu.php'); ?>
				<!-- end: sidebar -->

				<section role="main" class="content-body card-margin">
					<header class="page-header">
						<h2>View Product Details</h2>
					</header>

					<!-- start: page -->
						<div class="row">
							<div class="col">
								<section class="card">
									<form class="form-horizontal form-bordered" method="post" enctype="multipart/form-data">
									<header class="card-header">
										<div class="card-actions">
											<a href="#" class="card-action card-action-toggle" data-card-toggle></a>
											<a href="#" class="card-action card-action-dismiss" data-card-dismiss></a>
										</div>
						
										<h2 class="card-title">View Product Details</h2>
									</header>
									<div class="card-body">										
											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2" for="inputDefault">Product Name</label>
												<div class="col-lg-6">
													<input type="text" name="pname" value="<?php echo $re['pname']; ?>" class="form-control" id="inputDefault" Disabled>
												</div>
											</div>

											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2" for="inputDefault">UPC</label>
												<div class="col-lg-6">
													<input type="text" name="upc" value="<?php echo $re['upc']; ?>" class="form-control" id="inputDefault" Disabled>
												</div>
											</div>

											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2" for="inputDefault">Category</label>
												<div class="col-lg-6">
													<input type="text"value="<?php echo $re['category']; ?>" class="form-control" id="inputDefault" Disabled>
												</div>
											</div>


											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2" for="textareaDefault">Sort Description</label>
												<div class="col-lg-10 border border-secondary rounded shadow p-3 mb-5">
													<p><?php echo $re['sdesc'];?></p>
												</div>
											</div>
											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2" for="textareaAutosize">Long Description</label>
												<div class="col-lg-10 border border-secondary rounded shadow p-3 mb-5">
													<p><?php echo $re['ldesc'];?></p>
												</div>
											</div>


											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2">Product Thumbnail</label>
												<div class="col-lg-10">
														<div style="margin-top: 15px;">
														<a class="img-thumbnail lightbox" href="<?php if($re['pthumb']!=""){ echo $pthumbpath.'/'.$re['pthumb']; }else { echo 'items/noimage.jpg'; } ?>" data-plugin-options="{ &quot;type&quot;:&quot;image&quot; }" title="<?php echo $re['pname']; ?>">
															<img src="<?php if($re['pthumb']!=""){ echo $pthumbpath.'/'.$re['pthumb']; }else { echo 'items/noimage.jpg'; } ?>" style="width: 100px; height: auto;" ></a>

														</div>
												</div>
											</div>

											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2">Product Images</label>
												<div class="col-lg-10 d-flex flex-wrap" style="gap: 10px;">
													
													<?php 
													$images = ['pimage', 'pimage2', 'pimage3', 'pimage4', 'pimage5'];
													foreach ($images as $imgKey) { 
														$imgSrc = !empty($re[$imgKey]) ? $pimgpath.'/'.$re[$imgKey] : 'items/noimage.jpg';
													?>
														<a class="img-thumbnail lightbox" href="<?php echo $imgSrc; ?>" 
														data-plugin-options='{"type":"image"}' 
														title="<?php echo $re['pname']; ?>">
															<img src="<?php echo $imgSrc; ?>" style="width:100px; height:auto;">
														</a>
													<?php } ?>
													
												</div>
											</div>
											<!-- Quantity -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Quantity</label>
                                    <div class="col-lg-6">
                                        <input type="number" name="quantity" value="<?= $re['quantity'] ?>" class="form-control" min="1" required  Disabled>
                                    </div>
                                </div>
                                <!-- Availability -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Availability</label>
                                    <div class="col-lg-6">
                                        <select name="availability" class="form-control" required  Disabled>
                                            <option value="Yes" <?= ($re['availability']=='Yes')?'selected':'' ?>>Yes</option>
                                            <option value="No" <?= ($re['availability']=='No')?'selected':'' ?>>No</option>
                                        </select>
                                    </div>
                                </div>
                                <!-- Delivery Time -->
                                <div class="form-group row">
                                    <label class="col-lg-2 control-label text-lg-right pt-2">Time to Deliver</label>
                                    <div class="col-lg-6">
                                        <input type="text" name="delivery_time" value="<?= $re['delivery_time'] ?>" class="form-control" required  Disabled>
                                    </div>
                                </div>
											<!-- Colors -->
											<div class="form-group row" id="color-field-group">
												<label class="col-lg-2 control-label text-lg-right pt-2">Colors</label>
												<div class="col-lg-6">
													<?php 
													$colorList = explode(',', $re['colors']);
													foreach ($colorList as $i => $color) { 
														$color = trim($color); // remove spaces
													?>
														<div class="input-group mb-2 align-items-center">
															<!-- Color Circle -->
															<span style="
																width: 25px; 
																height: 25px; 
																border-radius: 50%; 
																background-color: <?= $color ?>; 
																display: inline-block; 
																border: 1px solid #ccc;
																margin-right: 10px;">
															</span>
															
															<!-- Color Text -->
															<input type="text" name="colors[]" 
																value="<?= $color ?>" 
																class="form-control" 
																required disabled>
														</div>
													<?php } ?>
												</div>
											</div>



											<div class="form-group row">
												<label class="col-lg-2 control-label text-lg-right pt-2" for="inputDefault">Status</label>
												<div class="col-lg-6">

													<input type="text" value="<?php if($re['status']==0){echo "Disable"; } else { echo "Enable"; } ?>" class="form-control" id="inputDefault" Disabled>
												</div>
											</div>

										</div>

											<footer class="card-footer text-right">
											<a href="manage-product.php" class="btn btn-primary">Back </a>
											</footer>
									</form>
								</section>
							</div>
						</div>
												
					<!-- end: page -->
				</section>
			</div>

		</section>
		<script src="vendor/jquery/jquery.js"></script>
		<script src="vendor/jquery-browser-mobile/jquery.browser.mobile.js"></script>
		<script src="vendor/popper/umd/popper.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.js"></script>
		<script src="vendor/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
		<script src="vendor/common/common.js"></script>
		<script src="vendor/nanoscroller/nanoscroller.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.js"></script>
		<script src="vendor/jquery-placeholder/jquery.placeholder.js"></script>
		<script src="vendor/autosize/autosize.js"></script>
		<script src="vendor/bootstrap-fileupload/bootstrap-fileupload.min.js"></script>
		<script src="js/theme.js"></script>
		<script src="js/custom.js"></script>
		<script src="js/theme.init.js"></script>
	</body>
</html>