<?php
session_start();
include 'dbconn.php';

if (!isset($_SESSION['user_id'])) {
    echo "Login required";
    exit;
}

$user_id = $_SESSION['user_id'];

// Get order_id (from POST or GET)
$order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : (isset($_GET['order_id']) ? intval($_GET['order_id']) : 0);

if ($order_id <= 0) {
    echo "Invalid request";
    exit;
}

// Verify order
$sql = "SELECT first_name, last_name, email, order_date, status, grand_total 
        FROM orders WHERE id = ? AND user_id = ?";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("ii", $order_id, $user_id);
$stmt->execute();
$result = $stmt->get_result();
$order = $result->fetch_assoc();

if (!$order) {
    echo "Order not found";
    exit;
}

$order_time   = strtotime($order['order_date']);
$current_time = time();
$time_diff    = $current_time - $order_time;

// Allow cancel only within 1 hour and if still Pending
if ($time_diff > 3600 || $order['status'] != 'Pending') {
    echo "Cancellation not allowed";
    exit;
}

// Cancel order
$update = $mysqli->prepare("UPDATE orders SET status = 'Cancelled' WHERE id = ?");
$update->bind_param("i", $order_id);
$update->execute();

/** ---------------- SEND CANCELLATION MAIL ---------------- **/
$to      = $order['email'];
$subject = "Your Order #$order_id has been Cancelled";
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: info@bhavik.kitret.com" . "\r\n";

$message = "
<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <title>Order Cancelled</title>
</head>
<body style='margin:0;padding:0;background-color:#FAFAFA;font-family:Arial,sans-serif;'>
  <div style='background-color:#FAFAFA;padding:20px 0;'>
    <table align='center' width='600' cellpadding='0' cellspacing='0' 
           style='background:#fff;border:1px solid #e06666;border-radius:8px;overflow:hidden;'>
      
      <!-- ✅ Logo -->
      <tr>
        <td align='center' style='padding:20px;'>
          <img src='https://fjldusj.stripocdn.email/content/guids/CABINET_16e121cdd3958cc292dbd12ff9305248140210590ab6a793520a0bdc45bd7bb7/images/logo.png' 
               alt='CrafsyAngel Logo' width='150' height='80' style='display:block;margin:0 auto;'>
        </td>
      </tr>

      <!-- ❌ Cancel Header -->
      <tr>
        <td align='center' style='padding:20px;background:#dc3545;color:#fff;font-size:20px;font-weight:bold;'>
          ❌ Your order has been Cancelled
        </td>
      </tr>

     
      <!-- ✅ Message -->
      <tr>
        <td style='padding:20px;color:#333;font-size:14px;line-height:1.6;'>
          <p>Dear <b>".$order['first_name']." ".$order['last_name']."</b>,</p>
          <p>Your order with ID <b>#$order_id</b> placed on 
             <b>".date("d M Y H:i", strtotime($order['order_date']))."</b> 
             has been <b style='color:red;'>Cancelled</b>.</p>
          
          <p><b>Grand Total:</b> ₹".$order['grand_total']."</p>

          <p>If this was a mistake or you need help, please contact our support team.</p>

          <div style='margin-top:20px;text-align:center;'>
            <a href='https://bhavik.kitret.com/craftsy-angel/' 
               style='background:#c27ba0;color:#fff;text-decoration:none;
                      padding:12px 25px;border-radius:6px;font-size:16px;'>
              Keep Shopping
            </a>
          </div>
        </td>
      </tr>

      <!-- ✅ Footer -->
      <tr>
        <td style='background:#f1f1f1;padding:10px;text-align:center;
                   font-size:12px;color:#555;'>
          © ".date("Y")." CrafsyAngel. All rights reserved.
        </td>
      </tr>
    </table>
  </div>
</body>
</html>
";

mail($to, $subject, $message, $headers);

// Redirect back with success message
header("Location: my-account.php?status=cancelled&order_id=" . $order_id);
exit;
?>
