<?php
session_start();
include 'dbconn.php';

if (!isset($_SESSION['user_id'])) {
    echo "Login required";
    exit;
}

if (!isset($_GET['order_id'])) {
    echo "Invalid request";
    exit;
}

$order_id = intval($_GET['order_id']);
$user_id = $_SESSION['user_id'];

$sql = "
    SELECT 
        o.id AS order_id,
        o.order_date,
        o.status,
        oi.quantity,
        oi.price,
        oi.color,
        oi.personalize_name,
        oi.personalize_message,
        p.pname,
        p.pthumb
    FROM orders o
    JOIN order_items oi ON o.id = oi.order_id
    JOIN product p ON oi.product_id = p.id
    WHERE o.user_id = ? AND o.id = ?
";

$stmt = $mysqli->prepare($sql);
$stmt->bind_param("ii", $user_id, $order_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo "<p>No details found.</p>";
    exit;
}

$order = [];
while ($row = $result->fetch_assoc()) {
    $order['info'] = [
        'order_id' => $row['order_id'],
        'order_date' => $row['order_date'],
        'status' => $row['status']
    ];
    $order['items'][] = $row;
}

// Build UI
?>
<div>
  <p><strong>Order ID:</strong> <?php echo $order['info']['order_id']; ?></p>
  <p><strong>Date:</strong> <?php echo date("M d, Y", strtotime($order['info']['order_date'])); ?></p>
  <p><strong>Status:</strong> <?php echo htmlspecialchars($order['info']['status']); ?></p>
</div>

<table class="table">
  <thead>
    <tr>
      <th>Image</th>
      <th>Product</th>
      <th>Quantity</th>
      <th>Price</th>
      <th>Total</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($order['items'] as $item): ?>
      <tr>
        <td><img src="Admin/uploads/thumb/<?php echo $item['pthumb']; ?>" width="50"></td>
    <td style="text-align:left; vertical-align:top;">
    <?php echo htmlspecialchars($item['pname']); ?>
    
    <!-- Display Personalization if exists -->
    <?php if (!empty($item['personalize_name']) || !empty($item['personalize_message'])): ?>
        <div style="font-size:12px;color:#555;margin-top:2px; text-align:left;">
            <?php if (!empty($item['personalize_name'])): ?>
                <div><strong>Name:</strong> <?php echo htmlspecialchars($item['personalize_name']); ?></div>
            <?php endif; ?>
            <?php if (!empty($item['personalize_message'])): ?>
                <div><strong>Message:</strong> <?php echo htmlspecialchars($item['personalize_message']); ?></div>
            <?php endif; ?>
        </div>
    <?php endif; ?>

    <!-- Display color if exists -->
    <?php if (!empty($item['color'])): ?>
        <div style="margin-top:2px; text-align:left;">
            <span style="display:inline-block;width:12px;height:12px;border-radius:50%;border:1px solid #ccc;background-color:<?php echo htmlspecialchars($item['color']); ?>;"></span>
            <small><?php echo ucfirst($item['color']); ?></small>
        </div>
    <?php endif; ?>
</td>


        <td><?php echo $item['quantity']; ?></td>
        <td>$<?php echo number_format($item['price'], 2); ?></td>
        <td>$<?php echo number_format($item['quantity'] * $item['price'], 2); ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
