<?php
session_start();
require 'dbconn.php'; // Your DB connection file

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['user-name'] ?? '');
    $password = trim($_POST['user-password'] ?? '');

    // Validation
    if (empty($username) || empty($password)) {
        echo "<script>alert('Please enter both username and password.'); window.history.back();</script>";
        exit;
    }

    // MD5 hash of entered password
    $hashedPassword = md5($password);

    // Check credentials
    $stmt = $mysqli->prepare("SELECT id, username FROM users WHERE username = ? AND password = ?");
    $stmt->bind_param("ss", $username, $hashedPassword);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        // Fetch user data
        $stmt->bind_result($userId, $userName);
        $stmt->fetch();

        // Set session
        $_SESSION['user_id']  = $userId;
        $_SESSION['username'] = $userName;

        // -------------------------------
        // 🔄 Merge guest wishlist & cart
        // -------------------------------

        // --- Wishlist ---
        if (isset($_SESSION['wishlist']) && is_array($_SESSION['wishlist'])) {
            $wishStmt       = $mysqli->prepare("SELECT 1 FROM wishlist WHERE user_id = ? AND product_id = ?");
            $insertWishStmt = $mysqli->prepare("INSERT INTO wishlist (user_id, product_id) VALUES (?, ?)");

            foreach ($_SESSION['wishlist'] as $pid) {
                $pid = (int) $pid;
                $wishStmt->bind_param("ii", $userId, $pid);
                $wishStmt->execute();
                $wishStmt->store_result();

                if ($wishStmt->num_rows === 0) {
                    $insertWishStmt->bind_param("ii", $userId, $pid);
                    $insertWishStmt->execute();
                }
            }

            $wishStmt->close();
            $insertWishStmt->close();
            unset($_SESSION['wishlist']);
        }

        // --- Cart ---
        if (isset($_SESSION['cart']) && is_array($_SESSION['cart'])) {
            $checkCartStmt  = $mysqli->prepare("SELECT id, quantity FROM cart WHERE user_id = ? AND product_id = ? AND color = ?");
            $updateCartStmt = $mysqli->prepare("UPDATE cart SET quantity = quantity + ? WHERE id = ?");
            $insertCartStmt = $mysqli->prepare("INSERT INTO cart (user_id, product_id, quantity, color) VALUES (?, ?, ?, ?)");

            foreach ($_SESSION['cart'] as $item) {
                $pid   = (int) $item['product_id'];
                $qty   = (int) $item['quantity'];
                $color = $item['color'] ?? '';

                $checkCartStmt->bind_param("iis", $userId, $pid, $color);
                $checkCartStmt->execute();
                $checkCartStmt->store_result();
                $checkCartStmt->bind_result($cartId, $existingQty);

                if ($checkCartStmt->num_rows > 0) {
                    $checkCartStmt->fetch();
                    $updateCartStmt->bind_param("ii", $qty, $cartId);
                    $updateCartStmt->execute();
                } else {
                    $insertCartStmt->bind_param("iiis", $userId, $pid, $qty, $color);
                    $insertCartStmt->execute();
                }
            }

            $checkCartStmt->close();
            $updateCartStmt->close();
            $insertCartStmt->close();
            unset($_SESSION['cart']);
        }

        // Redirect after login
        echo "<script>window.location.href='index.php';</script>";

    } else {
        echo "<script>alert('Invalid username or password!'); window.history.back();</script>";
    }

    $stmt->close();
    $mysqli->close();
}
