<?php
    include 'dbconn.php';
    session_start();

    $is_logged_in = isset($_SESSION['user_id']);
    $user_id      = $is_logged_in ? $_SESSION['user_id'] : null;

    $cart_items = [];
    $cart_ids   = []; // ✅ store all cart_ids here

    // ✅ Logged-in → fetch from DB
    if ($is_logged_in) {
        $sql = "SELECT c.id as cart_id, p.id as product_id, p.pname, p.upc, p.pthumb, c.quantity
            FROM cart c
            JOIN product p ON c.product_id = p.id
            WHERE c.user_id = $user_id";
        $result = mysqli_query($mysqli, $sql);
        while ($row = mysqli_fetch_assoc($result)) {
            $cart_items[] = $row;
            $cart_ids[]   = $row['cart_id']; // store cart_id
        }
    }

    // ✅ Guest → fetch from SESSION
    if (! $is_logged_in && isset($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $index => $item) {
            $pid = $item['product_id'];
            $res = mysqli_query($mysqli, "SELECT pname, upc, pthumb FROM product WHERE id='$pid'");
            if ($prod = mysqli_fetch_assoc($res)) {
                $cart_items[] = [
                    'cart_id'    => $index, // use array index as cart_id
                    'product_id' => $pid,
                    'pname'      => $prod['pname'],
                    'upc'        => $prod['upc'],
                    'pthumb'     => $prod['pthumb'],
                    'quantity'   => $item['quantity'],
                ];
                $cart_ids[] = $index; // store session cart_id
            }
        }
    }

    // ✅ Now you can use $cart_ids anywhere
    // Example: store all cart_ids as a comma separated string
    $cart_ids_str = implode(",", $cart_ids);
?>

<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
    <meta name="description" content="Mioca - Handmade Goods eCommerce HTML Template" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">

    </head>

<body>


    <header>
        <div class="header-main sticky-nav ">
            <div class="container position-relative">
                <div class="row">
                    <div class="col-auto align-self-center">
                        <div class="header-logo">
                            <a href="index.html"><img src="assets/images/logo/logo.png" alt="Site Logo" /></a>
                        </div>
                    </div>
                     <div class="col align-self-center d-none d-lg-block">
                            <div class="main-menu">
                                <ul>
                                    <li class="dropdown"><a href="index.php">Home</a>
                                    </li>
                                    <li><a href="about.html">About</a></li>
                                    <li><a href="products.php">Products</a></li>
                                    <li class="dropdown position-static"><a href="#">Shop <i
                                                class="fa fa-angle-down"></i></a>
                                         <ul class="sub-menu">
                                            <li><a href="bags.php">Bags</a></li>
                                            <li><a href="cake_topper.php">Cake Topper</a></li>
                                            <li><a href="hair_clip.php">Hair Clips</a></li>
                                            <li><a href="home_decor.php">Home Decor</a></li>
                                            <li><a href="keychain.php">Keychain</a></li>
                                            <li><a href="nursary_decor.php">Nursary Decor</a></li>
                                            <li><a href="plant_hanging.php">Plant Hanging</a></li>
                                            <li><a href="rainbow.php">Rainbow</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="contact.html">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                     <div class="col col-lg-auto align-self-center pl-0">
                            <div class="header-actions">
                                <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
                                    <i class="pe-7s-search"></i>
                                </a>
                                <div class="header-bottom-set dropdown">
                                    <button class="dropdown-toggle header-action-btn" data-bs-toggle="dropdown"><i
                                            class="pe-7s-users"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a class="dropdown-item" href="my-account.php">My account</a></li>
                                        <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
                                        <li><a class="dropdown-item" href="login.html">Sign in</a></li>
                                    </ul>
                                </div>
                                <a href="wishlist.php" class="header-action-btn">
                                    <i class="pe-7s-like"></i>
                                    <span class="header-action-num">01</span>
                                </a>
                                <a href="my_cart.php"
                                    class="header-action-btn ">
                                    <i class="pe-7s-shopbag"></i>
                                    <span class="header-action-num">01</span>
                                    </a>

                            </div>
                            </div>
                </div>
            </div>
        </div>
    </header>
    <div class="offcanvas-overlay"></div>


    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">Cart</h2>
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">Cart</li>
                    </ul>
                    </div>
            </div>
        </div>
    </div>
    <div class="cart-main-area pt-100px pb-100px">
        <div class="container">
            <h3 class="cart-page-title">Your cart items</h3>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <form action="#">
                       <div class="table-content table-responsive cart-table-content">
    <table>
        <thead>
            <tr>
                <th>Image</th>
                <th>Product Name</th>
                <th>Until Price</th>
                <th>Qty</th>
                <th>Subtotal</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $grand_total = 0;
                foreach ($cart_items as $row):
                    $subtotal = $row['upc'] * $row['quantity'];
                    $grand_total += $subtotal;
                ?>
						            <tr>
						                <td class="product-thumbnail">
						                    <a href="#"><img class="img-responsive ml-15px" src="Admin/uploads/thumb/<?php echo $row['pthumb']; ?>" alt="" /></a>
						                </td>
						                <td class="product-name"><a href="#"><?php echo $row['pname']; ?></a></td>
						                <td class="product-price-cart"><span class="amount" data-price="<?php echo $row['upc']; ?>">€<?php echo number_format($row['upc'], 2); ?></span></td>
						                    <td class="product-quantity">
                                                <div class="cart-plus-minus">
                                                    <div class="dec qtybutton">-</div>
                                                    <input class="cart-plus-minus-box" type="text" name="qtybutton"
                                                           value="<?php echo $row['quantity']; ?>"
                                                           data-cart-id="<?php echo $row['cart_id']; ?>" />
                                                    <div class="inc qtybutton">+</div>
                                                </div>
                                            </td>
						                <td class="product-subtotal"><span class="amount subtotal-amount">€<?php echo number_format($subtotal, 2); ?></span></td>
						                <td class="product-remove">

						                    <a href="delete_cart.php?id=<?php echo $row['cart_id']; ?>"><i class="fa fa-times"></i></a>
						                </td>
						            </tr>
						           <?php endforeach; ?>

        </tbody>
    </table>
</div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="cart-shiping-update-wrapper">
                                    <div class="cart-shiping-update">
                                        <a href="products.php">Continue Shopping</a>
                                    </div>
                                    <div class="cart-clear">
                                        <button>Update Shopping Cart</button>
                                        <a href="clear_cart.php">Clear Shopping Cart</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="row">


                        <div class="col-lg-12 col-md-12 mt-md-30px">
                            <div class="grand-totall">
                                <div class="title-wrap">
                                    <h4 class="cart-bottom-title section-bg-gary-cart">Cart Total</h4>
                                </div>
                                <h5>Total products <span>€<?php echo number_format($grand_total, 2); ?></span></h5>
                                <div class="total-shipping">
                                    <h5>Total shipping</h5>
                                    <ul>
                                        <li><input type="checkbox" /> Standard <span>€20.00</span></li>
                                        <li><input type="checkbox" /> Express <span>€30.00</span></li>
                                         <li><input type="checkbox" /> Free Shipping <span>€00.00</span></li>
                                    </ul>
                                </div>
                                <h4 class="grand-totall-title">Grand Total <span id="grandTotal">€<?php echo number_format($grand_total, 2); ?></span></h4>
                              <!-- Pass cart ids to checkout button -->
                                <a href="checkout.php?cart_ids=<?php echo urlencode($cart_ids_str); ?>">Proceed to Checkout</a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

     <!-- Footer Area Start -->
        <div class="footer-area">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="row">
                            <!-- Start single blog -->
                            <div class="col-md-8 col-sm-6 col-lg-4 mb-md-30px mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Craftsy Angel</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            Mcrame, crafted by the skilled hands <br>of the artisans at Craftsy Angel,<br> is a true testament to the beauty of hand-made creations.
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Account</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" href="about.html">About us</a></li>
                                                <li class="li"><a class="single-link" href="contact.html">Contact Us</a></li>
                                                <li class="li"><a class="single-link" href="return_policy.php">Return Policy</a></li>
                                                <li class="li"><a class="single-link" href="refund_policy.php">Refund Policy</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-sm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Shop </h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" href="bags.php">Bags</a></li>
                                                <li class="li"><a class="single-link" href="cake_topper.php">Cake Topper</a></li>
                                                <li class="li"><a class="single-link" href="hair_clip.php">Hair Clips</a></li>
                                                <li class="li"><a class="single-link" href="home_decor.php">Home Decor</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-4 col-lg-4 col-md-6 col-sm-6 pl-120px line-shape">
                                <div class="single-wedge ">

                                    <h4 class="footer-herading">Contact Us</h4>
                                    <div class="footer-links">

                                       <p><i class="pe-7s-phone"></i><span><a href="tel:+91 931 380 4653"> +91 931 380 4653</a></p>
                                        <p><i class="pe-7s-mail"></i><span><a href="mailto:info@craftsyangel.com"> info@craftsyangel.com</a></span></p>
                                        <p><i class="pe-7s-map-marker"></i> <span>Craftsy Angel,
                                                <br>
                                                Plot 504/1&2 GIDC Estate, Makarpura, Vadodara-390010, Gujarat, INDIA.</span> </p>

                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="line-shape-top">
                            <div class="row flex-md-row-reverse align-items-center">
                                <div class="col-md-6 text-center text-md-end">

                                </div>
                                <div class="col-md-6 text-center text-md-start">
                                    <p class="copy-text"> © 2025 <strong>Craftsy Angel</strong> | All Rights Received.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer Area End -->
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
       document.addEventListener('DOMContentLoaded', function() {
    const qtyInputs = document.querySelectorAll('.cart-plus-minus-box');
    const updateCartButton = document.querySelector('.cart-clear button');

    // Function to update cart totals via AJAX and reload the page
    const updateCartTotals = async (cartId, newQuantity) => {
        const url = 'update_cart.php';
        const data = new FormData();
        data.append('cart_id', cartId);
        data.append('quantity', newQuantity);

        try {
            const response = await fetch(url, {
                method: 'POST',
                body: data
            });
            const result = await response.json();

            if (result.status === 'success') {
                // Reload the page to display the updated data from the database
                window.location.reload();
            } else {
                console.error('Error updating cart:', result.message);
                alert('Failed to update cart. Please try again.');
            }
        } catch (error) {
            console.error('Fetch error:', error);
            alert('An error occurred. Please check your connection and try again.');
        }
    };

    // Event listener for "Update Shopping Cart" button
    updateCartButton.addEventListener('click', function(e) {
        e.preventDefault(); // Prevent form submission

        qtyInputs.forEach(input => {
            const cartId = input.dataset.cartId;
            const newQuantity = parseInt(input.value, 10);

            // Only update if the quantity has changed and is a valid number
            if (!isNaN(newQuantity) && newQuantity > 0 && newQuantity !== parseInt(input.defaultValue, 10)) {
                updateCartTotals(cartId, newQuantity);
            }
        });
    });
});
    </script>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    const qtyButtons = document.querySelectorAll('.qtybutton');

    qtyButtons.forEach(btn => {
        btn.addEventListener('click', function() {
            const input = this.parentElement.querySelector('.cart-plus-minus-box');
            let value = parseInt(input.value, 10);

            if (this.classList.contains('inc')) {
                value++;
            } else if (this.classList.contains('dec') && value > 1) {
                value--;
            }

            input.value = value;
        });
    });
});
</script>

</body>

</html>