<?php
    include 'dbconn.php';
?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
    <meta name="description" content="Mioca - Handmade Goods eCommerce HTML Template" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!-- Add site Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <!-- vendor css (Icon Font) -->
    <!-- <link rel="stylesheet" href="assets/css/vendor/bootstrap.bundle.min.css" />
    <link rel="stylesheet" href="assets/css/vendor/pe-icon-7-stroke.css" />
    <link rel="stylesheet" href="assets/css/vendor/font.awesome.css" /> -->

    <!-- plugins css (All Plugins Files) -->
    <!-- <link rel="stylesheet" href="assets/css/plugins/animate.css" />
    <link rel="stylesheet" href="assets/css/plugins/swiper-bundle.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/jquery-ui.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/nice-select.css" />
    <link rel="stylesheet" href="assets/css/plugins/venobox.css" /> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">

    <!-- Main Style -->
    <!-- <link rel="stylesheet" href="assets/css/style.css" /> -->

</head>

<body>


    <!-- Header Area Start -->
    <header>
        <div class="header-main sticky-nav ">
            <div class="container position-relative">
                <div class="row">
                    <div class="col-auto align-self-center">
                        <div class="header-logo">
                            <a href="index.html"><img src="assets/images/logo/logo.png" alt="Site Logo" /></a>
                        </div>
                    </div>
                     <div class="col align-self-center d-none d-lg-block">
                            <div class="main-menu">
                                <ul>
                                    <li class="dropdown"><a href="index.php">Home</a>
                                    </li>
                                    <li><a href="about.html">About</a></li>
                                    <li><a href="products.php">Products</a></li>
                                    <li class="dropdown position-static"><a href="#">Shop <i
                                                class="fa fa-angle-down"></i></a>
                                         <ul class="sub-menu">
                                            <li><a href="bags.php">Bags</a></li>
                                            <li><a href="cake_topper.php">Cake Topper</a></li>
                                            <li><a href="hair_clip.php">Hair Clips</a></li>
                                            <li><a href="home_decor.php">Home Decor</a></li>
                                            <li><a href="keychain.php">Keychain</a></li>
                                            <li><a href="nursary_decor.php">Nursary Decor</a></li>
                                            <li><a href="plant_hanging.php">Plant Hanging</a></li>
                                            <li><a href="rainbow.php">Rainbow</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="contact.html">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                     <!-- Header Action Start -->
                        <div class="col col-lg-auto align-self-center pl-0">
                            <div class="header-actions">
                                <!-- Single Wedge Start -->
                                <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
                                    <i class="pe-7s-search"></i>
                                </a>
                                <!-- Single Wedge End -->
                                <div class="header-bottom-set dropdown">
                                    <button class="dropdown-toggle header-action-btn" data-bs-toggle="dropdown"><i
                                            class="pe-7s-users"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a class="dropdown-item" href="my-account.php">My account</a></li>
                                        <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
                                        <li><a class="dropdown-item" href="login.html">Sign in</a></li>
                                    </ul>
                                </div>
                                <!-- Single Wedge Start -->
                                <a href="wishlist.php" class="header-action-btn">
                                    <i class="pe-7s-like"></i>
                                    <span class="header-action-num">01</span>
                                </a>
                                <!-- Single Wedge End -->
                                <a href="my_cart.php"
                                    class="header-action-btn ">
                                    <i class="pe-7s-shopbag"></i>
                                    <span class="header-action-num">01</span>
                                    <!-- <span class="cart-amount">€30.00</span> -->
                                </a>

                            </div>
                            <!-- Header Action End -->
                        </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Area End -->
    <div class="offcanvas-overlay"></div>


    <!-- breadcrumb-area start -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">Plant Hanging</h2>
                    <!-- breadcrumb-list start -->
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">Shop</li>
                         <li class="breadcrumb-item active">Plant Hanging</li>
                    </ul>
                    <!-- breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area end -->



    <!-- Shop Page Start  -->
    <div class="shop-category-area pt-100px pb-100px">
        <div class="container">
            <div class="row">
                <div class="col-12">

                    <!-- Shop Top Area Start -->
                    <div class="desktop-tab">
                        <div class="shop-top-bar d-flex">
                            <!-- Left Side End -->

                            <!-- Right Side Start -->
                            <form method="get" id="filterForm">
                                <div class="select-shoing-wrap d-flex align-items-center">
                                    <div class="shot-product">
                                        <p>Sort By:</p>
                                    </div>
                                    <div class="shop-select">
                                        <select name="sort" class="shop-sort" onchange="document.getElementById('filterForm').submit()">
                                            <option value="">Default</option>
                                            <option value="name_asc">Name, A to Z</option>
                                            <option value="name_desc">Name, Z to A</option>
                                            <option value="price_asc">Price, low to high</option>
                                            <option value="price_desc">Price, high to low</option>
                                        </select>
                                    </div>
                                </div>

                            </form>

                            <!-- Right Side End -->

                        </div>
                    </div>
                    <!-- Shop Top Area End -->



                    <!-- Shop Bottom Area Start -->
                    <div class="shop-bottom-area">

                        <!-- Tab Content Area Start -->
                        <div class="row">
                            <div class="col">
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="shop-grid">
                                        <div class="row mb-n-30px">
                                        <?php
                                            // Records per page
                                            $limit = 6;

                                            // Current page number
                                            $page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int) $_GET['page'] : 1;

                                            // Offset
                                            $start = ($page - 1) * $limit;

                                            // Base query (Home Decor)
                                            $sql = "
                                                SELECT p.*, c.category
                                                FROM product p
                                                INNER JOIN category c ON p.catid = c.id
                                                WHERE c.category = 'Plant-Hanging'
                                            ";

                                            // Sorting
                                            if (! empty($_GET['sort'])) {
                                                switch ($_GET['sort']) {
                                                    case 'name_asc':
                                                        $sql .= " ORDER BY p.pname ASC";
                                                        break;
                                                    case 'name_desc':
                                                        $sql .= " ORDER BY p.pname DESC";
                                                        break;
                                                    case 'price_asc':
                                                        $sql .= " ORDER BY p.upc ASC";
                                                        break;
                                                    case 'price_desc':
                                                        $sql .= " ORDER BY p.upc DESC";
                                                        break;
                                                }
                                            }

                                            // Count total records for pagination
                                            $count_sql     = "SELECT COUNT(*) AS total FROM ($sql) AS count_table";
                                            $count_result  = mysqli_query($mysqli, $count_sql);
                                            $total_records = mysqli_fetch_assoc($count_result)['total'];
                                            $total_pages   = ceil($total_records / $limit);

                                            // Add limit for current page
                                            $sql .= " LIMIT $start, $limit";

                                            $result = mysqli_query($mysqli, $sql);

                                            // Display products
                                            while ($row = mysqli_fetch_assoc($result)) {
                                                $image1 = 'Admin/uploads/thumb/' . $row['pthumb'];
                                                $image2 = ! empty($row['pthumb']) ? 'Admin/uploads/thumb/' . $row['pthumb'] : $image1;
                                            ?>
                                                <div class="col-md-3 col-sm-6 col-xs-6 mb-30px" data-aos="fade-up" data-aos-delay="200">
                                                    <div class="product">
                                                        <div class="thumb">
                                                            <a href="single-product.php?id=<?php echo $row['id'] ?>" class="image">
                                                                <img src="<?php echo $image1 ?>" alt="<?php echo htmlspecialchars($row['pname']) ?>" />
                                                                <img class="hover-image" src="<?php echo $image2 ?>" alt="<?php echo htmlspecialchars($row['pname']) ?>" />
                                                            </a>
                                                            <div class="actions">
                                                                <a href="add_to_wishlist.php?product_id=<?php echo $row['id'] ?>" class="action wishlist" title="Wishlist">
                                                                    <i class="pe-7s-like"></i>
                                                                </a>
                                                            </div>
                                                        </div>
                                                        <div class="content">
                                                            <span class="ratings">
                                                                <span class="rating-wrap">
                                                                    <span class="star" style="width: 100%"></span>
                                                                </span>
                                                            </span>
                                                            <h5 class="title">
                                                                <a href="single-product.php?id=<?php echo $row['id'] ?>"><?php echo htmlspecialchars($row['pname']) ?></a>
                                                            </h5>
                                                            <span class="price">
                                                                <span class="new">€                                                                                                                                                                                                                                                                                                                                                                                                                                          <?php echo number_format($row['upc'], 2) ?></span>
                                                            </span>
                                                        </div>
                                                          <a href="single-product.php?id=<?php echo $row['id']; ?>"
   title="Add To Cart"
   class="add-to-cart">Add To Cart</a>
                                                    </div>
                                                </div>
                                            <?php }?>


                                             </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                                <!-- Tab Content Area End -->

                                            <!-- Pagination -->
                        <div class="pro-pagination-style text-center text-lg-end mb-0" data-aos="fade-up" data-aos-delay="200">
                            <div class="pages">
                                <ul>
                                    <?php if ($page > 1): ?>
                                        <li class="li"><a class="page-link" href="?page=<?php echo $page - 1 ?>&sort=<?php echo $_GET['sort'] ?? '' ?>"><i class="fa fa-angle-left"></i></a></li>
                                    <?php endif; ?>

                                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                        <li class="li"><a class="page-link<?php echo($i == $page) ? 'active' : '' ?>" href="?page=<?php echo $i ?>&sort=<?php echo $_GET['sort'] ?? '' ?>"><?php echo $i ?></a></li>
                                    <?php endfor; ?>

                                    <?php if ($page < $total_pages): ?>
                                        <li class="li"><a class="page-link" href="?page=<?php echo $page + 1 ?>&sort=<?php echo $_GET['sort'] ?? '' ?>"><i class="fa fa-angle-right"></i></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <!-- Shop Bottom Area End -->
                </div>
            </div>
        </div>
    </div>
    <!-- Shop Page End  -->

     <!-- Footer Area Start -->
        <div class="footer-area">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="row">
                            <!-- Start single blog -->
                            <div class="col-md-8 col-sm-6 col-lg-4 mb-md-30px mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Craftsy Angel</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            Mcrame, crafted by the skilled hands <br>of the artisans at Craftsy Angel,<br> is a true testament to the beauty of hand-made creations.
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Account</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" href="about.html">About us</a></li>
                                                <li class="li"><a class="single-link" href="contact.html">Contact Us</a></li>
                                                <li class="li"><a class="single-link" href="return_policy.php">Return Policy</a></li>
                                                <li class="li"><a class="single-link" href="refund_policy.php">Refund Policy</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-sm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Shop </h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" href="bags.php">Bags</a></li>
                                                <li class="li"><a class="single-link" href="cake_topper.php">Cake Topper</a></li>
                                                <li class="li"><a class="single-link" href="hair_clip.php">Hair Clips</a></li>
                                                <li class="li"><a class="single-link" href="home_decor.php">Home Decor</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-4 col-lg-4 col-md-6 col-sm-6 pl-120px line-shape">
                                <div class="single-wedge ">

                                    <h4 class="footer-herading">Contact Us</h4>
                                    <div class="footer-links">

                                       <p><i class="pe-7s-phone"></i><span><a href="tel:+91 931 380 4653"> +91 931 380 4653</a></p>
                                        <p><i class="pe-7s-mail"></i><span><a href="mailto:info@craftsyangel.com"> info@craftsyangel.com</a></span></p>
                                        <p><i class="pe-7s-map-marker"></i> <span>Craftsy Angel,
                                                <br>
                                                Plot 504/1&2 GIDC Estate, Makarpura, Vadodara-390010, Gujarat, INDIA.</span> </p>

                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="line-shape-top">
                            <div class="row flex-md-row-reverse align-items-center">
                                <div class="col-md-6 text-center text-md-end">

                                </div>
                                <div class="col-md-6 text-center text-md-start">
                                    <p class="copy-text"> © 2025 <strong>Craftsy Angel</strong> | All Rights Received.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer Area End -->

    <!-- Search Modal Start -->
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <!-- Search Modal End -->





    <!-- Global Vendor, plugins JS -->

    <!-- Vendor JS -->
    <!-- <script src="assets/js/vendor/jquery-3.5.1.min.js"></script>

    <script src="assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="assets/js/vendor/jquery-migrate-3.3.0.min.js"></script>
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script> -->

    <!--Plugins JS-->
    <!-- <script src="assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="assets/js/plugins/jquery-ui.min.js"></script>
    <script src="assets/js/plugins/jquery.nice-select.min.js"></script>
    <script src="assets/js/plugins/countdown.js"></script>
    <script src="assets/js/plugins/scrollup.js"></script>
    <script src="assets/js/plugins/jquery.zoom.min.js"></script>
    <script src="assets/js/plugins/venobox.min.js"></script>
    <script src="assets/js/plugins/ajax-mail.js"></script> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>

    <!-- Main Js -->
    <script src="assets/js/main.js"></script>
</body>
</html>