<?php
session_start();
require 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: verify_code.php');
    exit;
}

$otp   = isset($_POST['otp']) ? trim($_POST['otp']) : '';
$email = isset($_SESSION['reset_email']) ? $_SESSION['reset_email'] : '';

if (empty($email) || empty($otp)) {
    $_SESSION['error'] = 'Missing data. Please try again.';
    header('Location: verify_code.php');
    exit;
}

// Fetch latest matching unused code for that email
$stmt = $mysqli->prepare("SELECT id, code, expires_at, used FROM password_resets WHERE email = ? AND code = ? ORDER BY created_at DESC LIMIT 1");
$stmt->bind_param('ss', $email, $otp);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    if ($row['used']) {
        $_SESSION['error'] = 'This code has already been used. Request a new one.';
        header('Location: forgot_password.php');
        exit;
    }

    $now     = new DateTime();
    $expires = new DateTime($row['expires_at']);
    if ($now > $expires) {
        $_SESSION['error'] = 'This code has expired. Please request a new one.';
        header('Location: forgot_password.php');
        exit;
    }

    // Mark this reset row as used (optional) and allow password reset
    $update = $mysqli->prepare("UPDATE password_resets SET used = 1 WHERE id = ?");
    $update->bind_param('i', $row['id']);
    $update->execute();
    $update->close();

    // Save a flag to let user access reset page (short-lived)
    $_SESSION['can_reset'] = true;
    // keep reset_email as well
    $_SESSION['reset_email'] = $email;

    header('Location: reset_password.php'); // this should be the UI page you provided (reset pass)
    exit;

} else {
    $_SESSION['error'] = 'Invalid code. Please try again.';
    header('Location: verify_code.php');
    exit;
}
