<?php
include 'dbconn.php';

$data     = json_decode(file_get_contents("php://input"), true);
$catid    = isset($data['catid']) ? (int) $data['catid'] : 0;
$subcatid = isset($data['subcatid']) ? (int) $data['subcatid'] : 0;
$page     = isset($data['page']) ? (int) $data['page'] : 1;
$search   = isset($data['search']) ? trim($data['search']) : '';

$limit  = 6;
$offset = ($page - 1) * $limit;

$where = "WHERE 1 ";
if ($catid > 0) {
    $where .= "AND catid = $catid ";
}
if ($subcatid > 0) {
    $where .= "AND subcatid = $subcatid ";
}
if (! empty($search)) {
    $safeSearch = mysqli_real_escape_string($mysqli, $search);
    $where .= "AND (pname LIKE '%$safeSearch%' OR upc LIKE '%$safeSearch%') ";
}

// Count total records
$count_sql    = "SELECT COUNT(*) as total FROM product $where";
$count_result = mysqli_query($mysqli, $count_sql);
$total        = mysqli_fetch_assoc($count_result)['total'];
$totalPages   = ceil($total / $limit);

// Fetch paginated products
$sql    = "SELECT * FROM product $where LIMIT $limit OFFSET $offset";
$result = mysqli_query($mysqli, $sql);

$output = '';
while ($row = mysqli_fetch_assoc($result)) {
    $output .= '
    <div class="col-lg-4 col-md-6 col-sm-6 col-xs-6 mb-30px">
        <div class="product">
            <div class="thumb">
                <a href="single-product.php?id=' . $row['id'] . '" class="image">
                    <img src="Admin/uploads/thumb/' . $row['pthumb'] . '" alt="Product" />
                    <img class="hover-image" src="Admin/uploads/thumb/' . $row['pthumb'] . '" alt="Product" />
                </a>
                <div class="actions">
                    <a href="add_to_wishlist.php?product_id=' . $row['id'] . '" class="action wishlist" title="Wishlist"><i class="pe-7s-like"></i></a>
                </div>
            </div>
            <div class="content caption-bg">
                <span class="ratings pt-3">
                    <span class="rating-wrap"><span class="star" style="width: 100%"></span></span>
                    <span class="rating-num">(5 Review)</span>
                </span>
                <h5 class="title"><a href="single-product.php?id=' . $row['id'] . '">' . $row['pname'] . '</a></h5>
                <span class="price"><span class="new">£' . $row['upc'] . '</span></span>
            </div>
            <a href="single-product.php?id=' . $row['id'] . '" title="Add To Cart" class="add-to-cart">Add To Cart</a>
        </div>
    </div>';
}

// Add pagination only if there are products
if ($total > 0) {
    $output .= '<div class="pro-pagination-style text-center mt-0 mb-40px"><div class="pages"><ul>';
    for ($i = 1; $i <= $totalPages; $i++) {
        $active = $i === $page ? 'active' : '';
        $output .= '<li class="li"><a class="page-link ' . $active . '" href="#" data-page="' . $i . '">' . $i . '</a></li>';
    }
    $output .= '</ul></div></div>';
} else {
    $output = '<p>No products found.</p>';
}

echo $output;
