<?php
session_start();
require 'dbconn.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: forgot_password.php');
    exit;
}

$email = isset($_POST['email']) ? trim($_POST['email']) : '';
if (! filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $_SESSION['error'] = 'Please enter a valid email.';
    header('Location: forgot_password.php');
    exit;
}

// Check if email exists in customers table
$stmt = $mysqli->prepare("SELECT id FROM users WHERE email = ?");
$stmt->bind_param('s', $email);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows === 0) {
    // For security, we show a generic message but still do nothing
    $_SESSION['success'] = 'If this email is registered, a verification code has been sent.';
    header('Location: verify_code.php');
    exit;
}
$stmt->close();

// Generate 6-digit numeric OTP
$code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);

// Set expiry (5 minutes from now)
$expires_at = date('Y-m-d H:i:s', time() + 5 * 60);

// Insert into password_resets (mark used=0). You may choose to soft-delete old entries.
$insert = $mysqli->prepare("INSERT INTO password_resets (email, code, expires_at, used) VALUES (?, ?, ?, 0)");
$insert->bind_param('sss', $email, $code, $expires_at);
$ok = $insert->execute();
$insert->close();

if (! $ok) {
    $_SESSION['error'] = 'Server error. Please try again later.';
    header('Location: forgot_password.php');
    exit;
}

// Send email - try mail() by default. You can replace with PHPMailer (see notes).
$subject = "Password Reset Verification Code";

$message = '
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <title>Password Reset</title>
    <style>
      body {
        font-family: "Poppins", Arial, sans-serif;
        background-color: #f7f9fc;
        margin: 0;
        padding: 0;
      }
      .email-container {
        max-width: 600px;
        margin: 30px auto;
        background: #ffffff;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        overflow: hidden;
      }
      .email-header {
        background: linear-gradient(135deg, #e5097f, #e5097f);
        color: white;
        text-align: center;
        padding: 25px 10px;
      }
      .email-header h2 {
        margin: 0;
        font-size: 24px;
        letter-spacing: 0.5px;
      }
      .email-body {
        padding: 30px;
        color: #333333;
      }
      .email-body p {
        font-size: 15px;
        line-height: 1.6;
        margin-bottom: 15px;
      }
      .otp-box {
        background: #f1f3ff;
        color: #2c2c2c;
        text-align: center;
        font-size: 28px;
        font-weight: 700;
        letter-spacing: 6px;
        padding: 18px;
        border-radius: 10px;
        margin: 25px 0;
      }
      .email-footer {
        text-align: center;
        font-size: 13px;
        color: #888;
        border-top: 1px solid #eee;
        padding: 15px;
      }
      .email-footer a {
        color: #4c6ef5;
        text-decoration: none;
      }
    </style>
  </head>
  <body>
    <div class="email-container">
      <div class="email-header">
        <h2>Craftsy Angel</h2>
      </div>
      <div class="email-body">
        <p>Hello,</p>
        <p>We received a request to reset your password. Use the verification code below to continue:</p>

        <div class="otp-box">' . htmlspecialchars($code) . '</div>

        <p>This code will expire in <strong>5 minutes</strong>.</p>
        <p>If you didn’t request this, please ignore this email. Your account will remain secure.</p>

        <p>Thank you,<br><strong>Team Craftsy Angel</strong></p>
      </div>
      <div class="email-footer">
        © ' . date("Y") . ' Craftsy Angel. All rights reserved.<br>
      </div>
    </div>
  </body>
</html>
';

$headers  = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: Craftsy Angel <info@bhavik.kitret.com>\r\n";
$headers .= "Reply-To: info@bhavik.kitret.com\r\n";


// Try PHP mail()
$mail_sent = @mail($email, $subject, $message, $headers);

// If mail() fails, still proceed but inform user to check spam or contact support
if ($mail_sent) {
    $_SESSION['success'] = 'Verification code sent to your email.';
} else {
    // Not fatal; still save the code so user (or admin) can debug. You could log this error.
    $_SESSION['warning'] = 'Unable to send email via mail(); if you don\'t receive it, contact site admin.';
    $_SESSION['success'] = 'Verification code generated. Check your email (or spam).';
}

// store the email in session temporarily for verification step
$_SESSION['reset_email'] = $email;

// redirect to verify page
header('Location: verify_code.php');
exit;
