<?php
    include 'contctn.php';
    include 'session-chk.php';

    // ✅ Handle mail sending
    if (isset($_POST['send_mail'])) {
        $emails  = isset($_POST['emails']) ? $_POST['emails'] : '';
        $message = $_POST['message'];

        if (! empty($emails)) {
            $emailArray = explode(",", $emails);

            foreach ($emailArray as $to) {
                $to = trim($to);
                if (! empty($to)) {
                    $subject = "Newsletter";
                    $headers = "MIME-Version: 1.0" . "\r\n";
                    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                    $headers .= "From: bhavikpoojainfotech@gmail.com";
                    mail($to, $subject, $message, $headers);
                }
            }

            echo "<script>alert('Newsletter sent successfully!'); window.location='send-mail.php';</script>";
        } else {
            echo "<script>alert('No emails selected!');</script>";
        }
    }

    // ✅ Fetch all newsletter emails
    $query = "SELECT * from newsletter";
    $r1    = mysqli_query($db, $query);
?>
<!doctype html>
<html class="fixed">
	<head>
		<meta charset="UTF-8">
		<title>Send Newsletter</title>
		<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.css" />
		<link rel="stylesheet" href="vendor/font-awesome/css/all.min.css" />
		<link rel="stylesheet" href="css/theme.css" />
		<link rel="stylesheet" href="css/custom.css">
		<script src="vendor/modernizr/modernizr.js"></script>
		<script src="https://cdn.ckeditor.com/4.22.1/standard/ckeditor.js"></script>
	</head>
	<body>
		<section class="body">
			<?php include 'header.php'; ?>
			<div class="inner-wrapper">
				<?php include 'sidemenu.php'; ?>

				<section role="main" class="content-body card-margin">
					<header class="page-header">
						<h2>Send Newsletter</h2>

    </header>

					<div class="row">
						<div class="col">
							<section class="card">
								<header class="card-header">
									<h2 class="card-title">Compose & Send</h2>

    </header>

								<div class="card-body">
									<form method="POST">
										<!-- Recipients box -->
										<div class="form-group">
											<label>Recipients (To:)</label>
											<textarea name="emails" id="emails" class="form-control" rows="2" placeholder="Click 'Select Recipients' to choose"></textarea>
										</div>

										<!-- Button to open modal -->
										<button type="button" class="btn btn-primary mb-3" data-toggle="modal" data-target="#emailModal">
											Select Recipients
										</button>

										<!-- CKEditor for message -->
										<div class="form-group">
											<label>Message</label>
											<textarea name="message" id="editor"></textarea>
										</div>
										<script>
											CKEDITOR.replace('editor');
										</script>

										<br>
										<button type="submit" name="send_mail" class="btn btn-success">Send Mail</button>
									</form>
								</div>
							</section>
						</div>
					</div>
				</section>
			</div>
		</section>

		<!-- Modal for emails -->
		<div class="modal fade" id="emailModal" tabindex="-1" role="dialog">
		  <div class="modal-dialog modal-lg" role="document">
		    <div class="modal-content">
		      <div class="modal-header">
		        <h5 class="modal-title">Select Emails</h5>
		        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
		          <span aria-hidden="true">&times;</span>
		        </button>
		      </div>
		      <div class="modal-body">
		        <div>
		        	<input type="checkbox" id="selectAllEmails"> <b>Select All</b>
		        </div>
		        <hr>
		        <div class="row">
		        	<?php while ($re = mysqli_fetch_assoc($r1)) {?>
		        		<div class="col-md-4">
		        			<label>
		        				<input type="checkbox" class="emailCheckbox" value="<?php echo $re['email']; ?>">
		        				<?php echo $re['email']; ?>
		        			</label>
		        		</div>
		        	<?php }?>
		        </div>
		      </div>
		      <div class="modal-footer">
		        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
		        <button type="button" class="btn btn-primary" id="insertEmails">OK</button>
		      </div>
		    </div>
		  </div>
		</div>

		<!-- JS -->
		<script src="vendor/jquery/jquery.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.js"></script>

		<script>
			// ✅ Select/Deselect all emails
			$('#selectAllEmails').on('click', function() {
				$('.emailCheckbox').prop('checked', this.checked);
			});

			// ✅ Insert selected emails into textarea
			$('#insertEmails').on('click', function(){
				let selected = [];
				$('.emailCheckbox:checked').each(function(){
					selected.push($(this).val());
				});
				if(selected.length > 0){
					let emails = selected.join(", ");
					$('#emails').val(emails);
				} else {
					$('#emails').val('');
				}
				$('#emailModal').modal('hide');
			});
		</script>

</body>
</html>
