<?php
    include 'contctn.php';
    include 'session-chk.php';

    $pimgpath   = "uploads/product";
    $pthumbpath = "uploads/thumb";

    if (isset($_GET['id'])) {
        $id = (int) $_GET['id'];

        // fetch order
        $q     = "SELECT * FROM orders WHERE id = $id";
        $fire  = mysqli_query($db, $q);
        $order = mysqli_fetch_assoc($fire);

        // fetch order items
        $items_sql = "SELECT oi.*, p.pname, p.pthumb, p.pimage
                  FROM order_items oi
                  JOIN product p ON oi.product_id = p.id
                  WHERE oi.order_id = $id";
        $items_res = mysqli_query($db, $items_sql);
    }
?>

<!doctype html>
<html class="fixed">
<head>
    <meta charset="UTF-8">
    <title>View Order Details</title>
    <link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.css" />
    <link rel="stylesheet" href="vendor/font-awesome/css/all.min.css" />
    <link rel="stylesheet" href="css/theme.css" />
    <link rel="stylesheet" href="css/custom.css">
</head>
<body>
<section class="body">
    <?php include 'header.php'; ?>
    <div class="inner-wrapper">
        <?php include 'sidemenu.php'; ?>
        <section role="main" class="content-body card-margin">
            <header class="page-header">
                <h2>View Order Details</h2>

    </header>

            <div class="row">
                <div class="col">
                    <section class="card">
                        <header class="card-header">
                            <h2 class="card-title">Order #<?php echo $order['id']; ?></h2>

    </header>
                        <div class="card-body">

                            <!-- Customer Info -->
                            <div class="form-group row">
                                <label class="col-lg-2 control-label text-lg-right pt-2">Customer</label>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control"
                                           value="<?php echo $order['first_name'] . " " . $order['last_name']; ?>" disabled>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-lg-2 control-label text-lg-right pt-2">Email / Phone</label>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control"
                                           value="<?php echo $order['email'] . " / " . $order['phone']; ?>" disabled>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-lg-2 control-label text-lg-right pt-2">Address</label>
                                <div class="col-lg-6">
                                    <textarea class="form-control" rows="3" disabled><?php
                                                                                         echo $order['address1'] . " " . $order['address2'] . "\n" .
                                                                                             $order['city'] . ", " . $order['state'] . " " . $order['zip'] . "\n" .
                                                                                         $order['country'];
                                                                                     ?></textarea>
                                </div>
                            </div>

                            <!-- Order Items Table -->
                            <div class="form-group row">
                                <label class="col-lg-2 control-label text-lg-right pt-2">Order Items</label>
                                <div class="col-lg-10">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>Image</th>
                                                <th>Product</th>
                                                <th>Quantity</th>
                                                <th>Price</th>
                                                <th>Total</th>
                                                <th>Color</th>
                                                <th>Personalize Name</th>
                                                <th>Personalize Message</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php while ($item = mysqli_fetch_assoc($items_res)) {?>
                                            <tr>
                                              <td>
                                                    <?php
                                                        $img = ! empty($item['pthumb']) ? $pthumbpath . '/' . $item['pthumb'] : 'items/noimage.jpg';
                                                        ?>
                                                    <a href="<?php echo $img; ?>" target="_blank">
                                                        <img src="<?php echo $img; ?>" style="width:60px; height:auto;" class="img-thumbnail">
                                                    </a>
                                                </td>

                                                <td><?php echo $item['pname']; ?></td>
                                                <td><?php echo $item['quantity']; ?></td>
                                                <td>£<?php echo $item['price']; ?></td>
                                                <td>£<?php echo $item['total']; ?></td>
                                                <td>
                                                    <?php if (! empty($item['color'])) {?>
                                                        <div style="width:20px; height:20px; border:1px solid #ccc;
                                                                    background-color:   <?php echo strtolower($item['color']); ?>;
                                                                    border-radius:4px;"
                                                             title="<?php echo $item['color']; ?>"></div>
                                                    <?php } else {echo "-";}?>
                                                </td>
                                                <td><?php echo ! empty($item['personalize_name']) ? $item['personalize_name'] : "-"; ?></td>
                                                <td><?php echo ! empty($item['personalize_message']) ? $item['personalize_message'] : "-"; ?></td>
                                            </tr>
                                        <?php }?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Order Summary -->
                            <div class="form-group row">
                                <label class="col-lg-2 control-label text-lg-right pt-2">Grand Total</label>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control"
                                           value="£<?php echo $order['grand_total']; ?>" disabled>
                                </div>
                            </div>
                            <form method="post" action="update-order-status.php">
    <input type="hidden" name="order_id" value="<?php echo $order['id']; ?>">
    <div class="form-group row">
        <label class="col-lg-2 control-label text-lg-right pt-2">Status</label>
        <div class="col-lg-4">
            <select name="status" class="form-control">
                <option value="Pending" <?php echo($order['status'] == 'Pending') ? 'selected' : ''; ?>>Pending</option>
                <option value="Accepted"<?php echo($order['status'] == 'Accepted') ? 'selected' : ''; ?>>Accepted</option>
                <option value="Processing" <?php echo($order['status'] == 'Processing') ? 'selected' : ''; ?>>Processing</option>
                <option value="Delivered"<?php echo($order['status'] == 'Delivered') ? 'selected' : ''; ?>>Delivered</option>
                <option value="Cancelled"   <?php echo($order['status'] == 'Cancelled') ? 'selected' : ''; ?>>Cancelled</option>
            </select>
        </div>
        <div class="col-lg-2">
            <button type="submit" class="btn btn-success">Update</button>
        </div>
    </div>
</form>


                            <div class="form-group row">
                                <label class="col-lg-2 control-label text-lg-right pt-2">Order Date</label>
                                <div class="col-lg-6">
                                    <input type="text" class="form-control"
                                           value="<?php echo $order['order_date']; ?>" disabled>
                                </div>
                            </div>

                        </div>
                        <footer class="card-footer text-right">
                            <a href="orders.php" class="btn btn-primary">Back</a>
                        </footer>
                    </section>
                </div>
            </div>
        </section>
    </div>
</section>

</body>
</html>
