<?php
    session_start();
    include 'dbconn.php';
    $session_id = session_id();
    $now        = date('Y-m-d H:i:s');

    // 1. Check if session already in active_users
    $sql    = "SELECT * FROM active_users WHERE session_id='$session_id'";
    $result = mysqli_query($mysqli, $sql);

    if (mysqli_num_rows($result) == 0) {
        // New visitor
        $sql = "INSERT INTO active_users (session_id, last_activity)
            VALUES ('$session_id', '$now')";
        mysqli_query($mysqli, $sql);

        // Permanent log
        $sql = "INSERT INTO user_sessions (session_id, start_time)
            VALUES ('$session_id', '$now')";
        mysqli_query($mysqli, $sql);
    } else {
        // Existing session → just update
        $sql = "UPDATE active_users SET last_activity='$now'
            WHERE session_id='$session_id'";
        mysqli_query($mysqli, $sql);
    }

    // 2. Clean up inactive users
    $expire_time = date('Y-m-d H:i:s', strtotime('-5 minutes'));
    $sql         = "SELECT session_id FROM active_users WHERE last_activity < '$expire_time'";
    $result      = mysqli_query($mysqli, $sql);

    while ($row = mysqli_fetch_assoc($result)) {
        $sid = $row['session_id'];

        // Close session in permanent log
        $sql2 = "UPDATE user_sessions SET end_time='$expire_time'
             WHERE session_id='$sid' AND end_time IS NULL";
        mysqli_query($mysqli, $sql2);
    }

    // Finally remove from active list
    $sql = "DELETE FROM active_users WHERE last_activity < '$expire_time'";
    mysqli_query($mysqli, $sql);

    $user_id = $_SESSION['user_id'] ?? 0; // if not logged in, 0 or guest

    $wishlist_count = 0;
    $cart_count     = 0;

    if ($user_id > 0) {
        // Wishlist count
        $wishlist_query = $mysqli->prepare("SELECT COUNT(*) FROM wishlist WHERE user_id = ?");
        $wishlist_query->bind_param("i", $user_id);
        $wishlist_query->execute();
        $wishlist_query->bind_result($wishlist_count);
        $wishlist_query->fetch();
        $wishlist_query->close();

        // Cart count
        $cart_query = $mysqli->prepare("SELECT COUNT(*) FROM cart WHERE user_id = ?");
        $cart_query->bind_param("i", $user_id);
        $cart_query->execute();
        $cart_query->bind_result($cart_count);
        $cart_query->fetch();
        $cart_query->close();
    }
?>
<!DOCTYPE html>
    <html lang="zxx">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="x-ua-compatible" content="ie=edge" />
        <meta name="robots" content="index, follow" />
        <title>Craftsy Angel – Where Gifting Meets Creativity</title>
      
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">
        <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
        <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
        <link rel="stylesheet" href="assets/css/style.min.css">
        <link href='https://fonts.googleapis.com/css?family=Delius+Swash+Caps' rel='stylesheet'>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

        
        

        <style>
           .instagram-gallery {
    background-color: #fdeaf8

    padding: 40px 0;

}

.insta-block {
    width: 16.66%; /* 6 blocks per row */
    aspect-ratio: 1 / 1; /* Keep it square */
    position: relative;
    overflow: hidden;
}

.insta-block img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
    border-radius: 0;
    transition: transform 0.3s ease;
}

.insta-hover {
    position: absolute;
    inset: 0;
    background-color: rgba(255, 255, 255, 0.8);
    color: #000;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.insta-block:hover .insta-hover {
    opacity: 1;
}

.insta-block:hover img {
    transform: scale(1.05);
}

.insta-hover i {
    margin-bottom: 8px;
}
/* Overlay */
#newsletter-overlay {
  display: none;
  position: fixed;
  top: 0; left: 0; width: 100%; height: 100%;
  background: rgba(0,0,0,0.6);
  z-index: 1000;
  justify-content: center;
  align-items: center;
}

/* Modal Box */
#newsletter-box {
  background: #fff;
  border-radius: 12px;
  width: 700px;
  max-width: 90%;
  display: flex;
  overflow: hidden;
  position: relative; /* important for close button positioning */
  box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}

/* Left side image */
#newsletter-box .image-side {
  flex: 1;
  background: url('assets/images/newsletter1.png') center/cover no-repeat;
  min-height: 300px;
}

/* Right side form */
#newsletter-box .form-side {
  flex: 1;
  padding: 30px;
  display: flex;
  flex-direction: column;
  justify-content: center;
}

#newsletter-box h2 { margin-bottom: 10px; }
#newsletter-box p { margin-bottom: 15px; color: #555; }
#newsletter-box input {
  width: 100%; padding: 10px; margin-bottom: 15px;
  border: 1px solid #ddd; border-radius: 6px;
}
#newsletter-box button {
  background: #e5097f; color: #fff; border: none;
  padding: 10px; width: 100%; border-radius: 6px;
  cursor: pointer;
}

/* Close button */
#newsletter-box .close-btn {
  position: absolute;
  top: 10px;
  right: 15px;
  cursor: pointer;
  font-size: 26px;
  font-weight: bold;
  color: #666;
  transition: color 0.2s;
}
#newsletter-box .close-btn:hover {
  color: #000;
}
        </style>
    </head>
    <body>


        <!-- Header Area Start -->
      <header>
  <div class="header-main sticky-nav position-relative">
    <div class="container position-relative">
      <div class="d-flex align-items-center justify-content-between py-2">
        <!-- Logo -->
        <div class="header-logo">
          <a href="index.php">
            <img src="assets/images/logo/logo.png" alt="Site Logo" style="max-height: 90px;" />
          </a>
        </div>

        <!-- 3-dot toggle button -->
        <button class="mobile-menu-toggle d-lg-none border-0 bg-transparent fs-3">
         <i class="fa fa-bars" style="color: #e5097f;"></i>
        </button>

        <!-- Main Menu (Desktop) -->
        <nav class="main-menu d-none d-lg-block">
          <ul class="d-flex align-items-center gap-4 list-unstyled mb-0">
            <li><a href="index.php">Home</a></li>
            <li><a href="about.html">About</a></li>
            <li><a href="products.php">Products</a></li>
            <li class="dropdown position-static">
              <a href="#">Shop <i class="fa fa-angle-down"></i></a>
              <ul class="sub-menu">
                <li><a href="bags.php">Bags</a></li>
                <li><a href="cake_topper.php">Cake Topper</a></li>
                <li><a href="hair_clip.php">Hair Clips</a></li>
                <li><a href="home_decor.php">Home Decor</a></li>
                <li><a href="keychain.php">Keychain</a></li>
                <li><a href="nursary_decor.php">Nursary Decor</a></li>
                <li><a href="plant_hanging.php">Plant Hanging</a></li>
                <li><a href="rainbow.php">Rainbow</a></li>
              </ul>
            </li>
            <li><a href="contact.html">Contact</a></li>
          </ul>
        </nav>

        <!-- Header Actions (Desktop) -->
        <div class="header-actions d-none d-lg-flex align-items-center gap-3">
          <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
            <i class="pe-7s-search"></i>
          </a>
          <div class="dropdown">
            <button class="dropdown-toggle header-action-btn border-0 bg-transparent" data-bs-toggle="dropdown">
              <i class="pe-7s-users"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
              <li><a class="dropdown-item" href="my-account.php">My account</a></li>
              <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
              <li><a class="dropdown-item" href="login.html">Sign in</a></li>
            </ul>
          </div>
          <a href="wishlist.php" class="header-action-btn">
            <i class="pe-7s-like"></i>
            
          </a>
          <a href="my_cart.php" class="header-action-btn">
            <i class="pe-7s-shopbag"></i>
            
          </a>
        </div>
      </div>
    </div>

    <!-- Mobile Menu (Now appears just under header) -->
    <div class="mobile-menu d-lg-none">
      <ul class="list-unstyled m-0 p-3">
        <li><a href="index.php">Home</a></li>
        <li><a href="about.html">About</a></li>
        <li><a href="products.php">Products</a></li>
        <li class="dropdown">
          <a href="#">Shop</a>
          <ul class="sub-menu list-unstyled ms-3">
            <li><a href="bags.php">Bags</a></li>
            <li><a href="cake_topper.php">Cake Topper</a></li>
            <li><a href="hair_clip.php">Hair Clips</a></li>
            <li><a href="home_decor.php">Home Decor</a></li>
            <li><a href="keychain.php">Keychain</a></li>
            <li><a href="nursary_decor.php">Nursary Decor</a></li>
            <li><a href="plant_hanging.php">Plant Hanging</a></li>
            <li><a href="rainbow.php">Rainbow</a></li>
          </ul>
        </li>
        <li><a href="contact.html">Contact</a></li>
      </ul>
    </div>
  </div>
</header>

        <!-- Header Area End -->

        <!-- Hero/Intro Slider Start -->
        <div class="section ">
            <div class="hero-slider swiper-container slider-nav-style-1 slider-dot-style-1">
                <!-- Hero slider Active -->
                <div class="swiper-wrapper">
                    <!-- Single slider item -->
    <div class="hero-slide-item slider-height swiper-slide d-flex bg-color1"
        data-bg-image="assets/images/slider-image/slider-bg-1.jpg">
    <div class="container align-self-center">
            <div class="row align-items-center">

                <!-- slider 1 -->
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 d-flex flex-column align-items-start" style="gap: 30px; padding-left: 40px; position: relative;">
                    <!-- Content -->
                    <div class="hero-slide-content slider-animated-1" style="max-width: 500px;">
                        <h2 class="title-1" style="line-height:0.9;">
                        <p style="text-align: left;">Handmade with Love</p>
                            <p style="font-size: 16px;text-align:left;font-weight:400;line-height:1.5;font-family:Rubik, sans-serif">
                               Every creation is crafted with care, creativity, and vibrant colors.
                                    Celebrate the beauty of traditional craftsmanship blended with modern design—
                                    perfect for brightening your home, elevating your décor, or gifting someone special with something truly meaningful.
                            </p>
                        </h2>
                        <!--<span class="price" style="display: block; margin: 15px 0;text-align:left">-->
                        <!--    <span class="old"><del>£25.00</del></span>-->
                        <!--    <span class="new" style="color: #e5097f !important;"> - £18.00</span>-->
                        <!--</span>-->
                        <a href="products.php" class="btn btn-primary text-uppercase">View Collection</a>
                    </div>
                </div>

                <!-- Right Side Product Image -->
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 d-flex justify-content-center position-relative">
                    <div class="show-case">
                        <div class="hero-slide-image">
                            <img src="assets/images/slider-image/slider-1.png" alt="Main Product" style="max-width: 100%; height: auto;" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


                    <!-- slider 2 -->
    <div class="hero-slide-item slider-height swiper-slide d-flex bg-color1"
        data-bg-image="assets/images/slider-image/slider-bg-1.jpg">
        <div class="container align-self-center">
            <div class="row align-items-center">
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 d-flex flex-column align-items-start" style="gap: 30px; padding-left: 40px; position: relative;">
                    <div class="hero-slide-content slider-animated-1" style="max-width: 500px;">
                        <h2 class="title-1" style="line-height:0.9;">
                        <p style="text-align: left;">Handcrafted with Passion</p>
                            <p style="font-size: 16px;text-align:left;font-weight:400;line-height:1.5;font-family:Rubik, sans-serif">
                                Discover beautifully made decor pieces inspired by nature, colour,
                                and creativity. Each artwork is carefully crafted to bring warmth,
                                style, and a unique charm to your living space.
                            </p>
                        </h2>
                        <!--<span class="price" style="display: block; margin: 15px 0;text-align:left">-->
                        <!--    <span class="old"><del>$50.00</del></span>-->
                        <!--    <span class="new" style="color: #e5097f !important;"> - $20.00</span>-->
                        <!--</span>-->
                        <a href="products.php" class="btn btn-primary text-uppercase">View Collection</a>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 d-flex justify-content-center position-relative">
                    <div class="show-case">
                        <div class="hero-slide-image">
                            <img src="assets/images/slider-image/slider-2.png" alt="Main Product" style="max-width: 100%; height: auto;" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
                    <!-- Single slider item -->
    <div class="hero-slide-item slider-height swiper-slide d-flex bg-color1"
        data-bg-image="assets/images/slider-image/slider-bg-1.jpg">
    <div class="container align-self-center">
            <div class="row align-items-center">

                <!-- slider 3 -->
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 d-flex flex-column align-items-start" style="gap: 30px; padding-left: 40px; position: relative;">
                    <!-- Content -->
                    <div class="hero-slide-content slider-animated-1" style="max-width: 500px;">
                        <h2 class="title-1" style="line-height:0.9;">
                        <p style="text-align: left;">Handmade with Care</p>
                            <p style="font-size: 16px;text-align:left;font-weight:400;line-height:1.5;font-family:Rubik, sans-serif">
                               Beautifully crafted table runners, coasters, and décor pieces made with precision and passion.
                                Each design blends traditional artistry with modern elegance—perfect for enhancing your home or gifting someone special.
                            </p>
                        </h2>
                        <!--<span class="price" style="display: block; margin: 15px 0;text-align:left">-->
                        <!--    <span class="old"><del>£25.00</del></span>-->
                        <!--    <span class="new" style="color: #e5097f !important;"> - £18.00</span>-->
                        <!--</span>-->
                        <a href="products.php" class="btn btn-primary text-uppercase">View Collection</a>
                    </div>
                </div>

                <!-- Right Side Product Image -->
                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 d-flex justify-content-center position-relative">
                    <div class="show-case">
                        <div class="hero-slide-image">
                            <img src="assets/images/slider-image/slider-3.png" alt="Main Product" style="max-width: 100%; height: auto;" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
                </div>
                <!-- Add Pagination -->
                <div class="swiper-pagination swiper-pagination-white"></div>
                <!-- Add Arrows -->
                <div class="swiper-buttons">
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>

        <!-- Hero/Intro Slider End -->

        <!-- Banner Area Start -->
        <div class="banner-area pt-100px pb-100px">
            <div class="container">
                <div class="row">
                    <div class="single-col">
                        <div class="single-banner">
                            <img src="assets/images/banner/1234.png" alt="">
                            <div class="banner-content">
                                <!--<span class="category">Best Seller</span>-->
                                <span class="title">Wall<br>Hanging 
                                    </span>
                                <a href="products.php" class="shop-link btn btn-primary text-uppercase">Shop
                                    Now</a>
                            </div>
                        </div>
                    </div>
                    <div class="single-col center-col">
                        <div class="single-banner">
                            <img src="assets/images/banner/111.png" alt="">
                            <div class="banner-content">
                                <!--<span class="category">Best Seller</span>-->
                                <span class="title">Decor that Grows  <br>  with Every Moment </span>
                                <a href="products.php" class="shop-link btn btn-primary text-uppercase">Shop
                                    Now</a>
                            </div>
                        </div>
                    </div>
                    <div class="single-col">
                        <div class="single-banner">
                            <img src="assets/images/banner/3.jpg" alt="">
                            <div class="banner-content">
                                <!--<span class="category">Best Seller</span>-->
                                <span class="title">Macrame<br> Bags
                                    </span>
                                <a href="products.php" class="shop-link btn btn-primary text-uppercase">Shop
                                    Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Banner Area End -->
        <!-- Product Area Start -->
        <div class="product-area">
            <div class="container">
                <!-- Section Title & Tab Start -->
                <div class="row">
                    <!-- Section Title Start -->
                    <div class="col-12">
                        <div class="section-title text-center mb-60px">
                            <h2 class="title">Popular Categories</h2>
                            <p style="font-size: 15px;">From elegant wall hangings to whimsical nursery decore, find handcrafted pieces made with love.
                            Don't miss our best-selling macrame bags — stylish, sustainable, and truly one of a kind!</p>
                        </div>
                        <!-- Tab Start -->
                          <div class="tab-slider swiper-container slider-nav-style-1 small-nav">
                            <ul class="product-tab-nav nav swiper-wrapper ">
                                <li class="nav-item swiper-slide"><a class="nav-link active" data-bs-toggle="tab"
                                        href="#Bags"> <img src="assets/images/icons/bag.png"
                                            alt=""><span class="text-design">Macrame Bags</span></a>
                                </li>

                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Nursary-Decore"> <img src="assets/images/icons/nursary.png"
                                            alt=""><span class="text-design">Nursary Decore</span></a>
                                </li>
                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Home-Decore"> <img src="assets/images/icons/homedecor.png"
                                            alt=""><span class="text-design">Home Decore</span></a>
                                </li>
                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Keychain"> <img src="assets/images/icons/keychain.png"
                                            alt=""><span class="text-design">Keychain</span></a>
                                </li>
                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Cake-topper"> <img src="assets/images/icons/caketopper.png"
                                            alt=""><span class="text-design">Cake Topper</span></a>
                                </li>
                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Hair-clip"> <img src="assets/images/icons/hairclip.png"
                                            alt=""><span class="text-design">Hair Clip</span></a>
                                </li>
                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Plant-hanging"> <img src="assets/images/icons/plant_hanging.png"
                                            alt=""><span class="text-design">Plant Hanging</span></a>
                                </li>
                                <li class="nav-item swiper-slide"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Rainbow"> <img src="assets/images/icons/rainbow.png"
                                            alt=""><span class="text-design">Rainbow</span></a>
                                </li>

                            </ul>
                        </div>
                       <!-- <div class="tab-slider slider-nav-style-1 small-nav">
                        <ul class="product-tab-nav nav d-flex justify-content-center flex-wrap" style="column-gap: 100px;">

                                <li class="nav-item "><a class="nav-link active" data-bs-toggle="tab"
                                        href="#Bags"> <img src="assets/images/icons/macramme.png"
                                            alt=""><span class="text-design">Macrame Bags</span></a>
                                </li>

                                <li class="nav-item "><a class="nav-link" data-bs-toggle="tab"
                                        href="#Nursary-Decore"> <img src="assets/images/icons/nursary.png"
                                            alt=""><span class="text-design">Nursary Decore</span></a>
                                </li>
                                <li class="nav-item "><a class="nav-link" data-bs-toggle="tab"
                                        href="#Home-Decore"> <img src="assets/images/icons/home.png"
                                            alt=""><span class="text-design">Home Decore</span></a>
                                </li>
                                <li class="nav-item "><a class="nav-link" data-bs-toggle="tab"
                                        href="#Wall-Hanging"> <img src="assets/images/icons/wall.png"
                                            alt=""><span class="text-design">Wall Hanging Art</span></a>
                                </li>
                                <li class="nav-item"><a class="nav-link" data-bs-toggle="tab"
                                        href="#Accessories"> <img src="assets/images/icons/accessories.png"
                                            alt=""><span class="text-design">Accessories</span></a>
                                </li>
                            </ul>
                        </div> -->
                        <!-- Tab End -->
                    </div>
                    <!-- Section Title End -->

                </div>
                <!-- Section Title & Tab End -->

                <div class="row">
                    <div class="col">
                        <div class="tab-content mt-60px">
                            <?php
                                $categories = [
                                    1 => ['tab_id' => 'Bags'],
                                    6 => ['tab_id' => 'Nursary-Decore'],
                                    4 => ['tab_id' => 'Home-Decore'],
                                    7 => ['tab_id' => 'Plant-hanging'],
                                    8 => ['tab_id' => 'Rainbow'],
                                    5 => ['tab_id' => 'Keychain'],
                                    2 => ['tab_id' => 'Cake-topper'],
                                    3 => ['tab_id' => 'Hair-clip'],
                                ];

                                foreach ($categories as $categoryId => $info) {
                                    $tabId  = $info['tab_id'];
                                    $active = ($tabId == 'Bags') ? 'show active' : '';

                                    echo '<div class="tab-pane fade ' . $active . '" id="' . $tabId . '">';
                                    echo '<div class="row">';

                                    // Fetch products for this category
                                    $stmt = $mysqli->prepare("SELECT * FROM product WHERE catid = ? LIMIT 4");

                                    $stmt->bind_param("i", $categoryId);
                                    $stmt->execute();
                                    $result = $stmt->get_result();

                                    while ($row = $result->fetch_assoc()) {
                                        echo '
                                        <div class="col-lg-4 col-xl-3 col-md-6 col-sm-6 col-xs-6 mb-30px">
                                            <div class="product">
                                                <div class="thumb">
                                                    <a href="single-product.php?id=' . $row['id'] . '" class="image">
                                                        <img src="Admin/uploads/thumb/' . $row['pthumb'] . '" alt="Product" />
                                                        <img class="hover-image" src="Admin/uploads/thumb/' . $row['pthumb'] . '" alt="Product" />
                                                    </a>
                                                    <div class="actions">
                                                        <a href="add_to_wishlist.php?product_id=' . $row['id'] . '" class="action wishlist" title="Wishlist"><i class="pe-7s-like"></i></a>

                                                    </div>
                                                </div>
                                                <div class="content caption-bg">
                                                    <span class="ratings pt-3">
                                                        <span class="rating-wrap"><span class="star" style="width: 100%"></span></span>
                                                        <span class="rating-num">( 5 Review )</span>
                                                    </span>
                                                    <h5 class="title"><a href="single-product.php?id=' . $row['id'] . '">' . $row['pname'] . '</a></h5>
                                                    <span class="price">
                                                        <span class="new">£' . $row['upc'] . '</span>
                                                    </span>
                                                </div>
                                               <a href="single-product.php?id=' . $row['id'] . '" title="Add To Cart" class="add-to-cart">Add To Cart</a>
                                            </div>
                                        </div>';
                                    }

                                    echo '</div></div>'; // Close row and tab
                                }
                            ?>
                            <!-- 1st tab start -->


                            <!-- 5th tab end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Product Area End -->

       <!-- Feature Area Srart -->
        <div class="feature-area pt-100px">
            <div class="container">
                <div class="feature-wrapper">
                    <div class="single-feture-col">
                        <!-- single item -->
                        <div class="single-feature">
                            <div class="feature-icon">
                                <img src="assets/images/icons/1.png" alt="">
                            </div>
                            <div class="feature-content">
                                <h4 class="title">100% Handcrafted</h4>
                                <span class="sub-title">Crafted entirely by skilled hands.</span>
                            </div>
                        </div>
                    </div>
                    <!-- single item -->
                    <div class="single-feture-col ">
                        <div class="single-feature">
                            <div class="feature-icon">
                                <img src="assets/images/icons/2.png" alt="">
                            </div>
                            <div class="feature-content">
                                <h4 class="title">Customizable Designs</h4>
                                <span class="sub-title">Designed the way you like it.</span>
                            </div>
                        </div>
                    </div>
                    <!-- single item -->
                    <div class="single-feture-col">
                        <div class="single-feature">
                            <div class="feature-icon">
                                <img src="assets/images/icons/3.png" alt="">
                            </div>
                            <div class="feature-content">
                                <h4 class="title">Eco-Friendly Crafting</h4>
                                <span class="sub-title">Eco-safe craftsmanship</span>
                            </div>
                        </div>
                        <!-- single item -->
                    </div>
                </div>
            </div>
        </div>
        <!-- Feature Area End -->


        <!-- Deal Area Start -->
        <div class="deal-area pb-100px pt-100px">
            <div class="container ">
                <div class="row">
                    <div class="col-12">
                        <div class="deal-inner deal-bg position-relative ptb-80px"
                            data-bg-image="assets/images/deal-img/deal-bg.jpg">
                            <div class="deal-wrapper">
                                <h3 class="title">Handmade Macrame Bags<br>
                                    & Offer</h3><br>
                                    <h5>Uniquely crafted bags made to add color, charm, and elegance to your everyday look.</h5><br>
                                <!--<span class="price">-->
                                <!--    <span class="old"> <del>£25.00</del></span>-->
                                <!--    <span class="new">- £18.00</span>-->
                                <!--</span>-->
                                <a href="bags.php" class="btn btn-lg btn-primary">Add To Cart</a>
                            </div>
                            <div class="deal-image">
                                <img class="img-fluid" src="assets/images/deal-img/woman.png" alt="">
                                <!--<div class="discount">-->
                                <!--    <h3>-20%</h3>-->
                                <!--</div>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Deal Area End -->



<!-- Instagram-style Blocks with Images -->
<div class="instagram-gallery d-flex flex-wrap justify-content-center">
    <div class="insta-block">
        <img src="assets/images/blog-image/1.png" alt="Insta 1">
       <a href="https://www.instagram.com/craftsyangel/"><div class="insta-hover">
            <i class="fab fa-instagram fa-2x"></i>
            <p>@craftsyangel</p>
        </div></a>
    </div>
    <div class="insta-block">
        <img src="assets/images/blog-image/2.png" alt="Insta 2">
        <a href="https://www.instagram.com/craftsyangel/"><div class="insta-hover">
            <i class="fab fa-instagram fa-2x"></i>
            <p>@craftsyangel</p>
        </div></a>
    </div>
    <div class="insta-block">
        <img src="assets/images/blog-image/3.png" alt="Insta 3">
       <a href="https://www.instagram.com/craftsyangel/"><div class="insta-hover">
            <i class="fab fa-instagram fa-2x"></i>
            <p>@craftsyangel</p>
        </div></a>
    </div>
    <div class="insta-block">
        <img src="assets/images/blog-image/4.png" alt="Insta 1">
       <a href="https://www.instagram.com/craftsyangel/"><div class="insta-hover">
            <i class="fab fa-instagram fa-2x"></i>
            <p>craftsyangel</p>
        </div></a>
    </div>
    <div class="insta-block">
        <img src="assets/images/blog-image/5.png" alt="Insta 2">
       <a href="https://www.instagram.com/craftsyangel/"><div class="insta-hover">
            <i class="fab fa-instagram fa-2x"></i>
            <p>craftsyangel</p>
        </div></a>
    </div>
    <div class="insta-block">
        <img src="assets/images/blog-image/i.png" alt="Insta 3">
       <a href="https://www.instagram.com/craftsyangel/"><div class="insta-hover">
            <i class="fab fa-instagram fa-2x"></i>
            <p>craftsyangel</p>
        </div></a>
    </div>
    <!-- Repeat for more blocks -->
</div>

        <!--  Blog area End -->

     <!-- Footer Area Start -->
        <div class="footer-area">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="row">
                            <!-- Start single blog -->
                            <div class="col-md-8 col-sm-6 col-lg-4 mb-md-30px mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Craftsy Angel</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            Macrame, crafted by the skilled hands <br>of the artisans at Craftsy Angel,<br> is a true testament to the beauty of hand-made creations.
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Account</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li" ><a class="single-link" style="color: #fff;" href="about.html">About us</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="contact.html">Contact Us</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="return_policy.php">Return Policy</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="refund_policy.php">Refund Policy</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-sm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Shop </h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" style="color: #fff;" href="bags.php">Bags</a></li>
                                                <li class="li"><a class="single-link"style="color: #fff;" href="cake_topper.php">Cake Topper</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="hair_clip.php">Hair Clips</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="home_decor.php">Home Decor</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-4 col-lg-4 col-md-6 col-sm-6 pl-120px line-shape">
                                <div class="single-wedge ">

                                    <h4 class="footer-herading">Contact Us</h4>
                                    <div class="footer-links">

                                       <p><i class="fa fa-whatsapp" style="color:#fff; font-size:22px; margin-right:10px;"></i><span><a class="single-link" href="tel:+91 98253 42222">+91 98253 42222</a></p>
                                        <p><i class="fa fa-envelope" style="color:#fff; font-size:22px; margin-right:10px;"></i><span><a class="single-link" href="mailto:info@craftsyangel.com">info@craftsyangel.com</a></span></p>
                                      <p> <i class="fa fa-instagram" style="color:#fff; font-size:22px; margin-right:10px;"></i><span style="color: White;"><a class="single-link" href="https://www.instagram.com/craftsyangel" target="_blank" >craftsyangel</a></span></p>

                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            
                            <!-- End single blog -->
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="line-shape-top">
                            <div class="row flex-md-row-reverse align-items-center">
                                <div class="col-md-6 text-center text-md-end">

                                </div>
                                <div class="col-md-6 text-center text-md-start">
                                    <p class="copy-text"> © 2025 <strong>Craftsy Angel</strong> | All Rights Received.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer Area End -->

       <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->

<div id="newsletter-overlay">
  <div id="newsletter-box">
    <!-- Close button -->
    <span class="close-btn" onclick="closeNewsletter()">&times;</span>

    <!-- Left Image -->
    <div class="image-side"></div>

    <!-- Right Form -->
    <div class="form-side">
      <h2>Join our Newsletter</h2>
      <p>Stay updated with our latest offers and products.</p>

      <!-- Form -->
      <form id="newsletter-form" action="subscribe.php" method="POST">
        <input type="email" name="email" placeholder="Enter your email" required>
        <button type="submit">Subscribe</button>

      </form>
    </div>
  </div>
</div>

        <!-- Modal end -->

        <!-- Global Vendor, plugins JS -->

        <!-- Vendor JS -->
        <script src="assets/js/vendor/jquery-3.5.1.min.js"></script>

        <script src="assets/js/vendor/bootstrap.bundle.min.js"></script>
        <script src="assets/js/vendor/jquery-migrate-3.3.0.min.js"></script>
        <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script> 

        <!--Plugins JS-->
        <script src="assets/js/plugins/swiper-bundle.min.js"></script>
        <script src="assets/js/plugins/jquery-ui.min.js"></script>
        <script src="assets/js/plugins/jquery.nice-select.min.js"></script>
        <script src="assets/js/plugins/countdown.js"></script>
        <script src="assets/js/plugins/scrollup.js"></script>
        <script src="assets/js/plugins/jquery.zoom.min.js"></script>
        <script src="assets/js/plugins/venobox.min.js"></script>
        <script src="assets/js/plugins/ajax-mail.js"></script> 

        <!-- Use the minified version files listed below for better performance and remove the files listed above -->
         <script>
// Always show after 3 seconds
window.addEventListener("load", function() {
  setTimeout(function() {
    document.getElementById("newsletter-overlay").style.display = "flex";
  }, 3000);
});

function closeNewsletter() {
  document.getElementById("newsletter-overlay").style.display = "none";
}

// Close when clicking outside the modal box
document.getElementById("newsletter-overlay").addEventListener("click", function(e) {
  if (e.target === this) { // only when clicking overlay, not box
    closeNewsletter();
  }
});
</script>
        <script src="assets/js/vendor/vendor.min.js"></script>
        <script src="assets/js/plugins/plugins.min.js"></script>

        <!-- Main Js -->
        <script src="assets/js/main.js"></script>

</body>
    </html>