<?php
    session_start();
    if (! isset($_SESSION['user_id'])) {
        header("Location: login.html");
        exit;
    }
    include 'dbconn.php'; // DB connection
    $user_id = $_SESSION['user_id'];

    // Fetch user data
    $sql = "SELECT *
        FROM users
        WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user   = $result->fetch_assoc();

?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
   
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!-- Add site Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <!-- vendor css (Icon Font) -->
    <!-- <link rel="stylesheet" href="assets/css/vendor/bootstrap.bundle.min.css" />
    <link rel="stylesheet" href="assets/css/vendor/pe-icon-7-stroke.css" />
    <link rel="stylesheet" href="assets/css/vendor/font.awesome.css" /> -->

    <!-- plugins css (All Plugins Files) -->
    <!-- <link rel="stylesheet" href="assets/css/plugins/animate.css" />
    <link rel="stylesheet" href="assets/css/plugins/swiper-bundle.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/jquery-ui.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/nice-select.css" />
    <link rel="stylesheet" href="assets/css/plugins/venobox.css" /> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">
     <link href='https://fonts.googleapis.com/css?family=Delius+Swash+Caps' rel='stylesheet'>

    <!-- Main Style -->
    <!-- <link rel="stylesheet" href="assets/css/style.css" /> -->
<style>
@keyframes bounce {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-20px);
    }
}
</style>
</head>

<body>


    <!-- Header Area Start -->
    <header>
  <div class="header-main sticky-nav position-relative">
    <div class="container position-relative">
      <div class="d-flex align-items-center justify-content-between py-2">
        <!-- Logo -->
        <div class="header-logo">
          <a href="index.php">
            <img src="assets/images/logo/logo.png" alt="Site Logo" style="max-height: 90px;" />
          </a>
        </div>

        <!-- 3-dot toggle button -->
        <button class="mobile-menu-toggle d-lg-none border-0 bg-transparent fs-3">
          <i class="fa fa-bars" style="color: #e5097f;"></i>
        </button>

        <!-- Main Menu (Desktop) -->
        <nav class="main-menu d-none d-lg-block">
          <ul class="d-flex align-items-center gap-4 list-unstyled mb-0">
            <li><a href="index.php">Home</a></li>
            <li><a href="about.html">About</a></li>
            <li><a href="products.php">Products</a></li>
            <li class="dropdown position-static">
              <a href="#">Shop <i class="fa fa-angle-down"></i></a>
              <ul class="sub-menu">
                <li><a href="bags.php">Bags</a></li>
                <li><a href="cake_topper.php">Cake Topper</a></li>
                <li><a href="hair_clip.php">Hair Clips</a></li>
                <li><a href="home_decor.php">Home Decor</a></li>
                <li><a href="keychain.php">Keychain</a></li>
                <li><a href="nursary_decor.php">Nursary Decor</a></li>
                <li><a href="plant_hanging.php">Plant Hanging</a></li>
                <li><a href="rainbow.php">Rainbow</a></li>
              </ul>
            </li>
            <li><a href="contact.html">Contact</a></li>
          </ul>
        </nav>

        <!-- Header Actions (Desktop) -->
        <div class="header-actions d-none d-lg-flex align-items-center gap-3">
          <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
            <i class="pe-7s-search"></i>
          </a>
          <div class="dropdown">
            <button class="dropdown-toggle header-action-btn border-0 bg-transparent" data-bs-toggle="dropdown">
              <i class="pe-7s-users"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
              <li><a class="dropdown-item" href="my-account.php">My account</a></li>
              <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
              <li><a class="dropdown-item" href="login.html">Sign in</a></li>
            </ul>
          </div>
          <a href="wishlist.php" class="header-action-btn">
            <i class="pe-7s-like"></i>
            
          </a>
          <a href="my_cart.php" class="header-action-btn">
            <i class="pe-7s-shopbag"></i>
            
          </a>
        </div>
      </div>
    </div>

    <!-- Mobile Menu (Now appears just under header) -->
    <div class="mobile-menu d-lg-none">
      <ul class="list-unstyled m-0 p-3">
        <li><a href="index.php">Home</a></li>
        <li><a href="about.html">About</a></li>
        <li><a href="products.php">Products</a></li>
        <li class="dropdown">
          <a href="#">Shop</a>
          <ul class="sub-menu list-unstyled ms-3">
            <li><a href="bags.php">Bags</a></li>
            <li><a href="cake_topper.php">Cake Topper</a></li>
            <li><a href="hair_clip.php">Hair Clips</a></li>
            <li><a href="home_decor.php">Home Decor</a></li>
            <li><a href="keychain.php">Keychain</a></li>
            <li><a href="nursary_decor.php">Nursary Decor</a></li>
            <li><a href="plant_hanging.php">Plant Hanging</a></li>
            <li><a href="rainbow.php">Rainbow</a></li>
          </ul>
        </li>
        <li><a href="contact.html">Contact</a></li>
      </ul>
    </div>
  </div>
</header>

    <!-- Header Area End -->
    <div class="offcanvas-overlay"></div>


    <!-- breadcrumb-area start -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">My Account</h2>
                    <!-- breadcrumb-list start -->
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">My Account</li>
                    </ul>
                    <!-- breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area end -->




    <!-- account area start -->
    <div class="account-dashboard pt-100px pb-100px">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-3 col-lg-3">
                    <!-- Nav tabs -->
                    <div class="dashboard_tab_button" data-aos="fade-up" data-aos-delay="0">
                        <ul role="tablist" class="nav flex-column dashboard-list">
                           <li><a href="#account-details" data-bs-toggle="tab" class="nav-link">Account details</a>
                            </li>
                            <li> <a href="#orders" data-bs-toggle="tab" class="nav-link">Orders</a></li>

                            <li><a href="#address" data-bs-toggle="tab" class="nav-link">Addresses</a></li>

                            <li><a href="logout.php" class="nav-link">logout</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-12 col-md-9 col-lg-9">
                    <!-- Tab panes -->
                    <div class="tab-content dashboard_content" data-aos="fade-up" data-aos-delay="200">
                        <div class="tab-pane fade show active" id="dashboard">
                            <h1>Welcome,                                                                                                                                                                                     <?php echo htmlspecialchars($_SESSION['username']); ?>!</h1>

                        </div>
                        <div class="tab-pane fade" id="orders">
                            <h4>Orders</h4>
                            <h6 style="color:red;">You Can Cancel You Order Within One Hour After Place Order..</h6>
                            <div class="table_page table-responsive">
                                <table>
                                    <thead>
                                        <tr>

                                            <th>Date</th>
                                            <!-- <th>Status</th> -->
                                            <th>Products</th>
                                            <th>Total</th>
                                            <th>Quantity</th>
                                            <th>View</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $sql = "
                                        SELECT
                                            o.id AS order_id,
                                            o.order_date,
                                            o.status,
                                            oi.quantity,
                                            oi.price,
                                            p.pname,
                                            p.pthumb
                                        FROM orders o
                                        JOIN order_items oi ON o.id = oi.order_id
                                        JOIN product p ON oi.product_id = p.id
                                        WHERE o.user_id = ?
                                        ORDER BY o.id DESC
                                    ";
                                        $stmt = $mysqli->prepare($sql);
                                        $stmt->bind_param("i", $user_id);
                                        $stmt->execute();
                                        $result = $stmt->get_result();

                                        $orders = [];
                                        while ($row = $result->fetch_assoc()) {
                                            $orders[$row['order_id']]['info'] = [
                                                'order_date' => $row['order_date'],
                                                'status'     => $row['status'],
                                            ];
                                            $orders[$row['order_id']]['items'][] = $row;
                                        }

                                        if (! empty($orders)):
                                            foreach ($orders as $order_id => $order):
                                                $total_amount = 0;
                                                $total_items  = 0;
                                                ob_start();
                                                foreach ($order['items'] as $item) {
                                                    $total_amount += $item['quantity'] * $item['price'];
                                                    $total_items += $item['quantity'];
                                                ?>
																						                                                    <!-- <img src="Admin/uploads/thumb/<?php echo $item['pthumb']; ?>"
				                                                                                                                            <div style="display:flex;align-items:center;gap:8px;margin-bottom:4px;">
																						                                                        alt="<?php echo htmlspecialchars($item['pname']); ?>"
																						                                                        style="width:35px;height:35px;object-fit:cover;border:1px solid #ddd;border-radius:4px;"> -->
																						                                                    <span><?php echo htmlspecialchars($item['pname']); ?> ×<?php echo $item['quantity']; ?></span>
																						                                                </div>
																						                                            <?php }
                                                                                                                                                $products_html = ob_get_clean();
                                                                                                                                            ?>
																						                                            <tr>

																						                                                <td><?php echo date("M d, Y", strtotime($order['info']['order_date'])); ?></td>
																						                                                <!-- <td>
																						                                                    <?php if ($order['info']['status'] == 'Delivered'): ?>
																						                                                        <span class="success">Delivered</span>
																						                                                    <?php else: ?>
									<?php echo htmlspecialchars($order['info']['status']); ?>
									<?php endif; ?>
                                                </td> -->
                                                <td>
                                                    <?php echo $products_html; ?>

                                                </td>
                                                <td>

                                                    <strong>$<?php echo number_format($total_amount, 2); ?></strong>

                                                </td>
                                                <td>
                                                    <?php echo $total_items; ?> item<?php echo($total_items > 1) ? 's' : ''; ?>
                                                </td>
                                            <td>
                                    <a href="javascript:void(0);"
                                        class="view btn-view-order"
                                        data-order-id="<?php echo $order_id; ?>">
                                        view
                                    </a>
                                    </td>
                                    <td>
    <?php
        // Calculate time difference in seconds
        $order_time   = strtotime($order['info']['order_date']);
        $current_time = time();
        $diff_in_secs = $current_time - $order_time;
        $status       = $order['info']['status'];

        // Show cancel button only if Pending + within 1 hour
    if ($status == 'Pending' && $diff_in_secs <= 3600): ?>
        <a href="cancel_order.php?order_id=<?php echo $order_id; ?>"
           class="btn-cancel-order"
           onclick="return confirm('Are you sure you want to cancel this order?');">
           Cancel Order
        </a>
    <?php else: ?>
        <span class="text-muted">
            <?php echo htmlspecialchars($status); ?>
        </span>
    <?php endif; ?>
</td>


                                            </tr>
                                        <?php endforeach;
                                        else: ?>
                                        <tr><td colspan="5">No orders found</td></tr>
                                    <?php endif; ?>
                                    </tbody>

                                </table>
                                <!-- Order Details Modal -->
                            <div class="modal fade" id="orderDetailsModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Order Details</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body" id="orderDetailsContent">
                                    <!-- Dynamic order details will be loaded here -->
                                </div>
                                </div>
                            </div>
                            </div>

                            </div>
                        </div>

                       <div class="tab-pane" id="address">
    <p>The following address will be used on the checkout page by default.</p>
    <h5 class="billing-address">Billing address</h5>

    <form action="update_address.php" method="post">
        <div class="default-form-box mb-20">
            <label>Full Name</label>
            <input type="text" name="full_name"
                   value="<?php echo htmlspecialchars($user['fname']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>Address</label>
            <input type="text" name="address"
                   value="<?php echo htmlspecialchars($user['address']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>City</label>
            <input type="text" name="city"
                   value="<?php echo htmlspecialchars($user['city']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>State</label>
            <input type="text" name="state"
                   value="<?php echo htmlspecialchars($user['state']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>ZIP Code</label>
            <input type="text" name="zip"
                   value="<?php echo htmlspecialchars($user['zip']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>Country</label>
            <input type="text" name="country"
                   value="<?php echo htmlspecialchars($user['country']); ?>">
        </div>

        <div class="save_button mt-3">
            <button class="btn" type="submit">Save Address</button>
        </div>
    </form>
</div>

                        <div class="tab-pane fade" id="account-details">
                            <h3>Account details </h3>
                            <br>
                            <div class="login">
                                <div class="login_form_container">
                                    <div class="account_login_form">
                                       <form action="update_account.php" method="post">

                                    <div class="input-radio">
                                        <span class="custom-radio">
                                            <input type="radio" value="1" name="id_gender"
                                                <?php if ($user['gender'] == 1) {
                                                        echo 'checked';
                                                }
                                                ?>> Mr.
                                        </span>
                                        <span class="custom-radio">
                                            <input type="radio" value="2" name="id_gender"
                                                <?php if ($user['gender'] == 2) {
                                                        echo 'checked';
                                                }
                                                ?>> Mrs.
                                        </span>
                                    </div>
                                    <br>

                                    <div class="default-form-box mb-20">
                                        <label>Name</label>
                                        <input type="text" name="first-name" value="<?php echo htmlspecialchars($user['fname']); ?>">
                                    </div>

                                    <div class="default-form-box mb-20">
                                        <label>Phone Number</label>
                                        <input type="text" name="last-name" value="<?php echo htmlspecialchars($user['phone']); ?>">
                                    </div>

                                    <div class="default-form-box mb-20">
                                        <label>Email</label>
                                        <input type="text" name="email-name" value="<?php echo htmlspecialchars($user['email']); ?>">
                                    </div>

                                   <div class="default-form-box mb-20">
                                        <label>Birthdate</label>
                                        <input type="date" name="birthday"
                                            value="<?php echo $user['birthday'] ? date('Y-m-d', strtotime($user['birthday'])) : ''; ?>">
                                    </div>

                                    <span class="example">(E.g.: 05/31/1970)</span>
                                    <br>

                                    <div class="save_button mt-3">
                                        <button class="btn" type="submit">Save</button>
                                    </div>

                                    </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- account area start -->

     <!-- Footer Area Start -->
        <div class="footer-area">
            <div class="footer-container">
                <div class="footer-top">
                    <div class="container">
                        <div class="row">
                            <!-- Start single blog -->
                            <div class="col-md-8 col-sm-6 col-lg-4 mb-md-30px mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Craftsy Angel</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            Macrame, crafted by the skilled hands <br>of the artisans at Craftsy Angel,<br> is a true testament to the beauty of hand-made creations.
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-lm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Account</h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li" ><a class="single-link" style="color: #fff;" href="about.html">About us</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="contact.html">Contact Us</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="return_policy.php">Return Policy</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="refund_policy.php">Refund Policy</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-8 col-lg-2 col-sm-6 mb-sm-30px">
                                <div class="single-wedge">
                                    <h4 class="footer-herading">Shop </h4>
                                    <div class="footer-links">
                                        <div class="footer-row">
                                            <ul class="align-items-center">
                                                <li class="li"><a class="single-link" style="color: #fff;" href="bags.php">Bags</a></li>
                                                <li class="li"><a class="single-link"style="color: #fff;" href="cake_topper.php">Cake Topper</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="hair_clip.php">Hair Clips</a></li>
                                                <li class="li"><a class="single-link" style="color: #fff;" href="home_decor.php">Home Decor</a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            <div class="col-md-4 col-lg-4 col-md-6 col-sm-6 pl-120px line-shape">
                                <div class="single-wedge ">

                                    <h4 class="footer-herading">Contact Us</h4>
                                    <div class="footer-links">

                                       <p><i class="fa fa-whatsapp" style="color:#fff; font-size:22px; margin-right:10px;"></i><span><a class="single-link" href="tel:+91 98253 42222">+91 98253 42222</a></p>
                                        <p><i class="fa fa-envelope" style="color:#fff; font-size:22px; margin-right:10px;"></i><span><a class="single-link" href="mailto:info@craftsyangel.com">info@craftsyangel.com</a></span></p>
                                      <p> <i class="fa fa-instagram" style="color:#fff; font-size:22px; margin-right:10px;"></i><span style="color: White;"><a class="single-link" href="https://www.instagram.com/craftsyangel" target="_blank" >craftsyangel</a></span></p>

                                    </div>
                                </div>
                            </div>
                            <!-- End single blog -->
                            <!-- Start single blog -->
                            
                            <!-- End single blog -->
                        </div>
                    </div>
                </div>
                <div class="footer-bottom">
                    <div class="container">
                        <div class="line-shape-top">
                            <div class="row flex-md-row-reverse align-items-center">
                                <div class="col-md-6 text-center text-md-end">

                                </div>
                                <div class="col-md-6 text-center text-md-start">
                                    <p class="copy-text"> © 2025 <strong>Craftsy Angel</strong> | All Rights Received.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Footer Area End -->
<div class="modal fade" id="orderSuccessModal" tabindex="-1" aria-labelledby="orderSuccessModalLabel" aria-hidden="true" style="font-family: Arial, sans-serif;">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
      <div class="modal-body text-center p-5" style="background: linear-gradient(135deg, #f0f9ff, #cbebff); border-radius: 15px;">
        <span class="celebration-icon" style="font-size: 80px; color: #4CAF50; animation: bounce 0.8s ease-in-out;">🎉</span>
        <h3 class="mt-4 mb-2" style="color: #333; font-weight: 700;">Order Placed Successfully!</h3>
        <p class="mb-4" style="color: #666; line-height: 1.6;">Your order has been confirmed and is now being processed.</p>
        <p style="color: #444; font-weight: bold;">Order ID: <span id="modalOrderId" style="color: #e5097f;"></span></p>
        <button type="button" class="btn btn-success mt-3" data-bs-dismiss="modal" style="background-color: #c41e76ff; border-color: #e5097f; border-radius: 25px; padding: 10px 30px; font-weight: 600;">
            Continue Shopping
        </button>
      </div>
    </div>
  </div>
</div>


    <!-- Search Modal Start -->
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <!-- Search Modal End -->

    <!-- Global Vendor, plugins JS -->

    <!-- Vendor JS -->
    <!-- <script src="assets/js/vendor/jquery-3.5.1.min.js"></script>

    <script src="assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="assets/js/vendor/jquery-migrate-3.3.0.min.js"></script>
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script> -->

    <!--Plugins JS-->
    <!-- <script src="assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="assets/js/plugins/jquery-ui.min.js"></script>
    <script src="assets/js/plugins/jquery.nice-select.min.js"></script>
    <script src="assets/js/plugins/countdown.js"></script>
    <script src="assets/js/plugins/scrollup.js"></script>
    <script src="assets/js/plugins/jquery.zoom.min.js"></script>
    <script src="assets/js/plugins/venobox.min.js"></script>
    <script src="assets/js/plugins/ajax-mail.js"></script> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>

    <!-- Main Js -->
    <script src="assets/js/main.js"></script>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const status = urlParams.get('status');
    const orderId = urlParams.get('order_id');

    if (status === 'success' && orderId) {
        document.getElementById('modalOrderId').textContent = orderId;
        var myModal = new bootstrap.Modal(document.getElementById('orderSuccessModal'));
        myModal.show();
        history.replaceState(null, '', window.location.pathname);
    }

    if (status === 'cancelled' && orderId) {
        alert("Order #" + orderId + " has been cancelled successfully.");
        history.replaceState(null, '', window.location.pathname);
    }
});

</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
  document.querySelectorAll(".btn-view-order").forEach(btn => {
    btn.addEventListener("click", function() {
      let orderId = this.getAttribute("data-order-id");

      fetch("get_order_details.php?order_id=" + orderId)
        .then(res => res.text())
        .then(data => {
          document.getElementById("orderDetailsContent").innerHTML = data;
          var modal = new bootstrap.Modal(document.getElementById("orderDetailsModal"));
          modal.show();
        });
    });
  });
});
</script>


</body>
</html>