<?php
include('contctn.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = (int) $_POST['order_id'];
    $status   = mysqli_real_escape_string($db, $_POST['status']);

    // Update DB
    $q = "UPDATE orders SET status = '$status' WHERE id = $order_id";
    if (mysqli_query($db, $q)) {
        
        // Fetch customer + product details
        $order_sql = "SELECT * FROM orders WHERE id = $order_id";
        $order_res = mysqli_query($db, $order_sql);
        $order = mysqli_fetch_assoc($order_res);

        $items_sql = "SELECT oi.*, p.pname, p.pthumb 
                      FROM order_items oi 
                      JOIN product p ON oi.product_id = p.id 
                      WHERE oi.order_id = $order_id";
        $items_res = mysqli_query($db, $items_sql);

        // Build Products HTML
        $products_html = '';
        while ($item = mysqli_fetch_assoc($items_res)) {
            $img = !empty($item['pthumb']) ? 'https://yourdomain.com/uploads/thumb/'.$item['pthumb'] : 'https://yourdomain.com/items/noimage.jpg';
            $products_html .= "
                <tr>
                    <td><img src='$img' width='60'></td>
                    <td>{$item['pname']}</td>
                    <td>{$item['quantity']}</td>
                    <td>₹{$item['total']}</td>
                </tr>";
        }

        // ✅ Status colors
        $statusColors = [
            "Accepted"   => "green",
            "Processing" => "blue",
            "Cancelled"  => "red",
            "Delivered"  => "orange" // (yellow is too light, so use orange for visibility)
        ];
        $color = isset($statusColors[$status]) ? $statusColors[$status] : "#333";

        // Email Subject & Body
        $subject = "Order Status Update - {$order['first_name']} {$order['last_name']}";
        $message = "
        <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; background:#f9f9f9; }
            .banner { background:#28a745; color:white; padding:12px; font-size:20px; font-weight:bold; text-align:center; }
            table { width:100%; border-collapse: collapse; margin-top:20px; background:white; }
            table, th, td { border:1px solid #ddd; padding:8px; text-align:center; }
            .status { font-weight:bold; font-size:18px; color:$color; }
          </style>
        </head>
        <body>
          <div class='banner'>Order Status Update</div>
          <p>Dear <strong>{$order['first_name']} {$order['last_name']}</strong>,</p>
          <p>Your order status has been updated to: <span class='status'>{$status}</span></p>
          <table>
            <thead>
              <tr>
                <th>Image</th><th>Product</th><th>Qty</th><th>Total</th>
              </tr>
            </thead>
            <tbody>
              $products_html
            </tbody>
          </table>
          <p style='margin-top:20px;'>Thank you for shopping with us!</p>
        </body>
        </html>";

        // Send Email
        $headers  = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: no-reply@yourdomain.com";

        mail($order['email'], $subject, $message, $headers);

        header("Location: view-order.php?id=$order_id&msg=updated");
        exit;
    }
}
?>
