<?php
    session_start();
    if (! isset($_SESSION['user_id'])) {
        header("Location: login.html");
        exit;
    }
    include 'dbconn.php'; // DB connection
    $user_id = $_SESSION['user_id'];

    // Fetch user data
    $sql = "SELECT *
        FROM users
        WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $user   = $result->fetch_assoc();

?>
<!DOCTYPE html>
<html lang="zxx">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
    <meta name="description" content="Mioca - Handmade Goods eCommerce HTML Template" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <!-- Add site Favicon -->
    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <!-- vendor css (Icon Font) -->
    <!-- <link rel="stylesheet" href="assets/css/vendor/bootstrap.bundle.min.css" />
    <link rel="stylesheet" href="assets/css/vendor/pe-icon-7-stroke.css" />
    <link rel="stylesheet" href="assets/css/vendor/font.awesome.css" /> -->

    <!-- plugins css (All Plugins Files) -->
    <!-- <link rel="stylesheet" href="assets/css/plugins/animate.css" />
    <link rel="stylesheet" href="assets/css/plugins/swiper-bundle.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/jquery-ui.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/nice-select.css" />
    <link rel="stylesheet" href="assets/css/plugins/venobox.css" /> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">

    <!-- Main Style -->
    <!-- <link rel="stylesheet" href="assets/css/style.css" /> -->
<style>
@keyframes bounce {
    0%, 100% {
        transform: translateY(0);
    }
    50% {
        transform: translateY(-20px);
    }
}
</style>
</head>

<body>


    <!-- Header Area Start -->
    <header>
        <div class="header-main sticky-nav ">
            <div class="container position-relative">
                <div class="row">
                    <div class="col-auto align-self-center">
                        <div class="header-logo">
                            <a href="index.html"><img src="assets/images/logo/logo.png" alt="Site Logo" /></a>
                        </div>
                    </div>
                     <div class="col align-self-center d-none d-lg-block">
                            <div class="main-menu">
                                <ul>
                                    <li class="dropdown"><a href="index.php">Home</a>
                                    </li>
                                    <li><a href="about.html">About</a></li>
                                    <li><a href="products.php">Products</a></li>
                                    <li class="dropdown position-static"><a href="#">Shop <i
                                                class="fa fa-angle-down"></i></a>
                                         <ul class="sub-menu">
                                            <li><a href="bags.php">Bags</a></li>
                                            <li><a href="cake_topper.php">Cake Topper</a></li>
                                            <li><a href="hair_clip.php">Hair Clips</a></li>
                                            <li><a href="home_decor.php">Home Decor</a></li>
                                            <li><a href="keychain.php">Keychain</a></li>
                                            <li><a href="nursary_decor.php">Nursary Decor</a></li>
                                            <li><a href="plant_hanging.php">Plant Hanging</a></li>
                                            <li><a href="rainbow.php">Rainbow</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="contact.html">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                     <!-- Header Action Start -->
                        <div class="col col-lg-auto align-self-center pl-0">
                            <div class="header-actions">
                                <!-- Single Wedge Start -->
                                <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
                                    <i class="pe-7s-search"></i>
                                </a>
                                <!-- Single Wedge End -->
                                <div class="header-bottom-set dropdown">
                                    <button class="dropdown-toggle header-action-btn" data-bs-toggle="dropdown"><i
                                            class="pe-7s-users"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a class="dropdown-item" href="my-account.php">My account</a></li>
                                        <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
                                        <li><a class="dropdown-item" href="login.html">Sign in</a></li>
                                    </ul>
                                </div>
                                <!-- Single Wedge Start -->
                                <a href="wishlist.php" class="header-action-btn">
                                    <i class="pe-7s-like"></i>
                                    <span class="header-action-num">01</span>
                                </a>
                                <!-- Single Wedge End -->
                                <a href="my_cart.php"
                                    class="header-action-btn ">
                                    <i class="pe-7s-shopbag"></i>
                                    <span class="header-action-num">01</span>
                                    <!-- <span class="cart-amount">€30.00</span> -->
                                </a>

                            </div>
                            <!-- Header Action End -->
                        </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Area End -->
    <div class="offcanvas-overlay"></div>


    <!-- breadcrumb-area start -->
    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">My Account</h2>
                    <!-- breadcrumb-list start -->
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">My Account</li>
                    </ul>
                    <!-- breadcrumb-list end -->
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb-area end -->




    <!-- account area start -->
    <div class="account-dashboard pt-100px pb-100px">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-3 col-lg-3">
                    <!-- Nav tabs -->
                    <div class="dashboard_tab_button" data-aos="fade-up" data-aos-delay="0">
                        <ul role="tablist" class="nav flex-column dashboard-list">
                           <li><a href="#account-details" data-bs-toggle="tab" class="nav-link">Account details</a>
                            </li>
                            <li> <a href="#orders" data-bs-toggle="tab" class="nav-link">Orders</a></li>

                            <li><a href="#address" data-bs-toggle="tab" class="nav-link">Addresses</a></li>

                            <li><a href="logout.php" class="nav-link">logout</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-12 col-md-9 col-lg-9">
                    <!-- Tab panes -->
                    <div class="tab-content dashboard_content" data-aos="fade-up" data-aos-delay="200">
                        <div class="tab-pane fade show active" id="dashboard">
                            <h1>Welcome,                                                                                 <?php echo htmlspecialchars($_SESSION['username']); ?>!</h1>

                        </div>
                        <div class="tab-pane fade" id="orders">
                            <h4>Orders</h4>
                            <div class="table_page table-responsive">
                                <table>
                                    <thead>
                                        <tr>

                                            <th>Date</th>
                                            <!-- <th>Status</th> -->
                                            <th>Products</th>
                                            <th>Total</th>
                                            <th>Quantity</th>
                                            <th>View</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $sql = "
                                        SELECT
                                            o.id AS order_id,
                                            o.order_date,
                                            o.status,
                                            oi.quantity,
                                            oi.price,
                                            p.pname,
                                            p.pthumb
                                        FROM orders o
                                        JOIN order_items oi ON o.id = oi.order_id
                                        JOIN product p ON oi.product_id = p.id
                                        WHERE o.user_id = ?
                                        ORDER BY o.id DESC
                                    ";
                                        $stmt = $mysqli->prepare($sql);
                                        $stmt->bind_param("i", $user_id);
                                        $stmt->execute();
                                        $result = $stmt->get_result();

                                        $orders = [];
                                        while ($row = $result->fetch_assoc()) {
                                            $orders[$row['order_id']]['info'] = [
                                                'order_date' => $row['order_date'],
                                                'status'     => $row['status'],
                                            ];
                                            $orders[$row['order_id']]['items'][] = $row;
                                        }

                                        if (! empty($orders)):
                                            foreach ($orders as $order_id => $order):
                                                $total_amount = 0;
                                                $total_items  = 0;
                                                ob_start();
                                                foreach ($order['items'] as $item) {
                                                    $total_amount += $item['quantity'] * $item['price'];
                                                    $total_items += $item['quantity'];
                                                ?>
				                                                <div style="display:flex;align-items:center;gap:8px;margin-bottom:4px;">
				                                                    <!-- <img src="Admin/Uploads/thumb/<?php echo $item['pthumb']; ?>"
				                                                        alt="<?php echo htmlspecialchars($item['pname']); ?>"
				                                                        style="width:35px;height:35px;object-fit:cover;border:1px solid #ddd;border-radius:4px;"> -->
				                                                    <span><?php echo htmlspecialchars($item['pname']); ?> ×<?php echo $item['quantity']; ?></span>
				                                                </div>
				                                            <?php }
                                                                        $products_html = ob_get_clean();
                                                                    ?>
				                                            <tr>

				                                                <td><?php echo date("M d, Y", strtotime($order['info']['order_date'])); ?></td>
				                                                <!-- <td>
				                                                    <?php if ($order['info']['status'] == 'Delivered'): ?>
				                                                        <span class="success">Delivered</span>
				                                                    <?php else: ?>
<?php echo htmlspecialchars($order['info']['status']); ?>
<?php endif; ?>
                                                </td> -->
                                                <td>
                                                    <?php echo $products_html; ?>

                                                </td>
                                                <td>

                                                    <strong>$<?php echo number_format($total_amount, 2); ?></strong>

                                                </td>
                                                <td>
                                                    <?php echo $total_items; ?> item<?php echo($total_items > 1) ? 's' : ''; ?>
                                                </td>
                                            <td>
                                    <a href="javascript:void(0);"
                                        class="view btn-view-order"
                                        data-order-id="<?php echo $order_id; ?>">
                                        view
                                    </a>
                                    </td>
                                    <td>
    <?php
        // Calculate time difference in seconds
        $order_time   = strtotime($order['info']['order_date']);
        $current_time = time();
        $diff_in_secs = $current_time - $order_time;
        $status       = $order['info']['status'];

        // Show cancel button only if Pending + within 1 hour
    if ($status == 'Pending' && $diff_in_secs <= 3600): ?>
        <a href="cancel_order.php?order_id=<?php echo $order_id; ?>"
           class="btn-cancel-order"
           onclick="return confirm('Are you sure you want to cancel this order?');">
           Cancel Order
        </a>
    <?php else: ?>
        <span class="text-muted">
            <?php echo htmlspecialchars($status); ?>
        </span>
    <?php endif; ?>
</td>


                                            </tr>
                                        <?php endforeach;
                                        else: ?>
                                        <tr><td colspan="5">No orders found</td></tr>
                                    <?php endif; ?>
                                    </tbody>

                                </table>
                                <!-- Order Details Modal -->
                            <div class="modal fade" id="orderDetailsModal" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-lg modal-dialog-centered">
                                <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Order Details</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body" id="orderDetailsContent">
                                    <!-- Dynamic order details will be loaded here -->
                                </div>
                                </div>
                            </div>
                            </div>

                            </div>
                        </div>

                       <div class="tab-pane" id="address">
    <p>The following address will be used on the checkout page by default.</p>
    <h5 class="billing-address">Billing address</h5>

    <form action="update_address.php" method="post">
        <div class="default-form-box mb-20">
            <label>Full Name</label>
            <input type="text" name="full_name"
                   value="<?php echo htmlspecialchars($user['fname']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>Address</label>
            <input type="text" name="address"
                   value="<?php echo htmlspecialchars($user['address']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>City</label>
            <input type="text" name="city"
                   value="<?php echo htmlspecialchars($user['city']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>State</label>
            <input type="text" name="state"
                   value="<?php echo htmlspecialchars($user['state']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>ZIP Code</label>
            <input type="text" name="zip"
                   value="<?php echo htmlspecialchars($user['zip']); ?>">
        </div>

        <div class="default-form-box mb-20">
            <label>Country</label>
            <input type="text" name="country"
                   value="<?php echo htmlspecialchars($user['country']); ?>">
        </div>

        <div class="save_button mt-3">
            <button class="btn" type="submit">Save Address</button>
        </div>
    </form>
</div>

                        <div class="tab-pane fade" id="account-details">
                            <h3>Account details </h3>
                            <br>
                            <div class="login">
                                <div class="login_form_container">
                                    <div class="account_login_form">
                                       <form action="update_account.php" method="post">

                                    <div class="input-radio">
                                        <span class="custom-radio">
                                            <input type="radio" value="1" name="id_gender"
                                                <?php if ($user['gender'] == 1) {
                                                        echo 'checked';
                                                }
                                                ?>> Mr.
                                        </span>
                                        <span class="custom-radio">
                                            <input type="radio" value="2" name="id_gender"
                                                <?php if ($user['gender'] == 2) {
                                                        echo 'checked';
                                                }
                                                ?>> Mrs.
                                        </span>
                                    </div>
                                    <br>

                                    <div class="default-form-box mb-20">
                                        <label>Name</label>
                                        <input type="text" name="first-name" value="<?php echo htmlspecialchars($user['fname']); ?>">
                                    </div>

                                    <div class="default-form-box mb-20">
                                        <label>Phone Number</label>
                                        <input type="text" name="last-name" value="<?php echo htmlspecialchars($user['phone']); ?>">
                                    </div>

                                    <div class="default-form-box mb-20">
                                        <label>Email</label>
                                        <input type="text" name="email-name" value="<?php echo htmlspecialchars($user['email']); ?>">
                                    </div>

                                   <div class="default-form-box mb-20">
                                        <label>Birthdate</label>
                                        <input type="date" name="birthday"
                                            value="<?php echo $user['birthday'] ? date('Y-m-d', strtotime($user['birthday'])) : ''; ?>">
                                    </div>

                                    <span class="example">(E.g.: 05/31/1970)</span>
                                    <br>

                                    <div class="save_button mt-3">
                                        <button class="btn" type="submit">Save</button>
                                    </div>

                                    </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- account area start -->

    <div class="newsletter-area ">
        <div class="container line-shape-bottom">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="newsletter-content mb-lm-30px">
                        <i class="pe-7s-mail-open-file"></i>
                        <div class="newsletter-text">
                            <h3 class="title">Newsletter & Get Updates</h3>
                            <p>Sign up for our newsletter to get update from us</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="news-letter-form">
                        <div id="mc_embed_signup" class="subscribe-form">
                            <form id="mc-embedded-subscribe-form" class="validate" novalidate="" target="_blank"
                                name="mc-embedded-subscribe-form" method="post"
                                action="http://devitems.us11.list-manage.com/subscribe/post?u=6bbb9b6f5827bd842d9640c82&amp;id=05d85f18ef"
                                >
                                <div id="mc_embed_signup_scroll" class="mc-form">
                                    <input class="email" type="email" required=""
                                        placeholder="Enter Your Mail Here......." name="EMAIL" value="">
                                    <div class="mc-news d-none" aria-hidden="true">
                                        <input type="text" value="" tabindex="-1"
                                            name="b_6bbb9b6f5827bd842d9640c82_05d85f18ef">
                                    </div>
                                    <div class="clear">
                                        <button id="mc-embedded-subscribe" class="button" type="submit" name="subscribe"
                                            value=""> Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer Area Start -->
    <div class="footer-area">
        <div class="footer-container">
            <div class="footer-top">
                <div class="container">
                    <div class="row">
                        <!-- Start single blog -->
                        <div class="col-md-6 col-sm-6 col-lg-3 mb-md-30px mb-lm-30px">
                            <div class="single-wedge">
                                <h4 class="footer-herading">Information</h4>
                                <div class="footer-links">
                                    <div class="footer-row">
                                        <ul class="align-items-center">
                                            <li class="li"><a class="single-link" href="about.html">About us</a></li>
                                            <li class="li"><a class="single-link" href="#">Delivery information</a></li>
                                            <li class="li"><a class="single-link" href="privacy-policy.html">Privacy
                                                    Policy</a></li>
                                            <li class="li"><a class="single-link" href="#">Sales</a></li>
                                            <li class="li"><a class="single-link" href="#">Terms & Conditions</a></li>
                                            <li class="li"><a class="single-link" href="#">Shipping Policy</a></li>
                                            <li class="li"><a class="single-link" href="#">EMI Payment</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End single blog -->
                        <!-- Start single blog -->
                        <div class="col-md-6 col-lg-3 col-sm-6 mb-lm-30px">
                            <div class="single-wedge">
                                <h4 class="footer-herading">Account</h4>
                                <div class="footer-links">
                                    <div class="footer-row">
                                        <ul class="align-items-center">
                                            <li class="li"><a class="single-link" href="my-account.php"> My account</a>
                                            </li>
                                            <li class="li"><a class="single-link" href="my_cart.php">My orders</a></li>
                                            <li class="li"><a class="single-link" href="#">Returns</a></li>
                                            <li class="li"><a class="single-link"
                                                    href="products.php">Shipping</a></li>
                                            <li class="li"><a class="single-link" href="wishlist.php">Wishlist</a></li>
                                            <li class="li"><a class="single-link" href="#">How Does It Work</a></li>
                                            <li class="li"><a class="single-link" href="#">Merchant Sign Up</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End single blog -->
                        <!-- Start single blog -->
                        <div class="col-md-6 col-lg-2 col-sm-6 mb-sm-30px">
                            <div class="single-wedge">
                                <h4 class="footer-herading">Store </h4>
                                <div class="footer-links">
                                    <div class="footer-row">
                                        <ul class="align-items-center">
                                            <li class="li"><a class="single-link" href="index.html">Affiliate</a></li>
                                            <li class="li"><a class="single-link"
                                                    href="products.php">Bestsellers</a></li>
                                            <li class="li"><a class="single-link" href="#">Discount</a></li>
                                            <li class="li"><a class="single-link" href="#">Latest products</a></li>
                                            <li class="li"><a class="single-link" href="#">Sale</a></li>
                                            <li class="li"><a class="single-link" href="#">All Collection</a></li>
                                            <li class="li"><a class="single-link" href="contact.html">Contact Us</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End single blog -->
                        <!-- Start single blog -->
                        <div class="col-md-6 col-lg-4 col-sm-6 pl-120px line-shape">
                            <div class="single-wedge ">

                                <h4 class="footer-herading">Contact Us</h4>
                                <div class="footer-links">
                                    <!-- News letter area -->
                                    <p class="mail">If you have any question.please <br>
                                        contact us at <a href="mailto:demo@example.com">demo@example.com</a> </p>
                                    <p class="address"><i class="pe-7s-map-marker"></i> <span>Your address goes here.
                                            <br>
                                            123, Address.</span> </p>
                                    <p class="phone m-0"><i class="pe-7s-phone"></i><span><a href="tel:0123456789">+ 0
                                                123
                                                456 789</a> <br> <a href="tel:0123456789">+ 0 123 456 789</a></span></p>

                                    <!-- News letter area  End -->
                                </div>
                            </div>
                        </div>
                        <!-- End single blog -->
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="container">
                    <div class="line-shape-top">
                        <div class="row flex-md-row-reverse align-items-center">
                            <div class="col-md-6 text-center text-md-end">
                                <div class="payment-mth"><a href="#"><img class="img img-fluid"
                                            src="assets/images/icons/payment.png" alt="payment-image"></a></div>
                            </div>
                            <div class="col-md-6 text-center text-md-start">
                                <p class="copy-text"> © 2021 <strong>Mioca.</strong> Made With <i class="fa fa-heart"
                                        aria-hidden="true"></i> By <a class="company-name"
                                        href="https://hasthemes.com/">
                                        <strong> HasThemes</strong></a>.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Footer Area End -->
<div class="modal fade" id="orderSuccessModal" tabindex="-1" aria-labelledby="orderSuccessModalLabel" aria-hidden="true" style="font-family: Arial, sans-serif;">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.1);">
      <div class="modal-body text-center p-5" style="background: linear-gradient(135deg, #f0f9ff, #cbebff); border-radius: 15px;">
        <span class="celebration-icon" style="font-size: 80px; color: #4CAF50; animation: bounce 0.8s ease-in-out;">🎉</span>
        <h3 class="mt-4 mb-2" style="color: #333; font-weight: 700;">Order Placed Successfully!</h3>
        <p class="mb-4" style="color: #666; line-height: 1.6;">Your order has been confirmed and is now being processed.</p>
        <p style="color: #444; font-weight: bold;">Order ID: <span id="modalOrderId" style="color: #e5097f;"></span></p>
        <button type="button" class="btn btn-success mt-3" data-bs-dismiss="modal" style="background-color: #c41e76ff; border-color: #e5097f; border-radius: 25px; padding: 10px 30px; font-weight: 600;">
            Continue Shopping
        </button>
      </div>
    </div>
  </div>
</div>


    <!-- Search Modal Start -->
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <!-- Search Modal End -->

    <!-- Global Vendor, plugins JS -->

    <!-- Vendor JS -->
    <!-- <script src="assets/js/vendor/jquery-3.5.1.min.js"></script>

    <script src="assets/js/vendor/bootstrap.bundle.min.js"></script>
    <script src="assets/js/vendor/jquery-migrate-3.3.0.min.js"></script>
    <script src="assets/js/vendor/modernizr-3.11.2.min.js"></script> -->

    <!--Plugins JS-->
    <!-- <script src="assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="assets/js/plugins/jquery-ui.min.js"></script>
    <script src="assets/js/plugins/jquery.nice-select.min.js"></script>
    <script src="assets/js/plugins/countdown.js"></script>
    <script src="assets/js/plugins/scrollup.js"></script>
    <script src="assets/js/plugins/jquery.zoom.min.js"></script>
    <script src="assets/js/plugins/venobox.min.js"></script>
    <script src="assets/js/plugins/ajax-mail.js"></script> -->

    <!-- Use the minified version files listed below for better performance and remove the files listed above -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>

    <!-- Main Js -->
    <script src="assets/js/main.js"></script>
    <script>
document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    const status = urlParams.get('status');
    const orderId = urlParams.get('order_id');

    if (status === 'success' && orderId) {
        document.getElementById('modalOrderId').textContent = orderId;
        var myModal = new bootstrap.Modal(document.getElementById('orderSuccessModal'));
        myModal.show();
        history.replaceState(null, '', window.location.pathname);
    }

    if (status === 'cancelled' && orderId) {
        alert("Order #" + orderId + " has been cancelled successfully.");
        history.replaceState(null, '', window.location.pathname);
    }
});

</script>
<script>
document.addEventListener("DOMContentLoaded", function() {
  document.querySelectorAll(".btn-view-order").forEach(btn => {
    btn.addEventListener("click", function() {
      let orderId = this.getAttribute("data-order-id");

      fetch("get_order_details.php?order_id=" + orderId)
        .then(res => res.text())
        .then(data => {
          document.getElementById("orderDetailsContent").innerHTML = data;
          var modal = new bootstrap.Modal(document.getElementById("orderDetailsModal"));
          modal.show();
        });
    });
  });
});
</script>

</body>
</html>