<?php
    include 'dbconn.php';
    session_start();

    $is_logged_in = isset($_SESSION['user_id']);
    $user_id      = $is_logged_in ? $_SESSION['user_id'] : null;

    $cart_items = [];
    $cart_ids   = []; // ✅ store all cart_ids here

    // ✅ Logged-in → fetch from DB
    if ($is_logged_in) {
        $sql = "SELECT c.id as cart_id, p.id as product_id, p.pname, p.upc, p.pthumb, c.quantity
            FROM cart c
            JOIN product p ON c.product_id = p.id
            WHERE c.user_id = $user_id";
        $result = mysqli_query($mysqli, $sql);
        while ($row = mysqli_fetch_assoc($result)) {
            $cart_items[] = $row;
            $cart_ids[]   = $row['cart_id']; // store cart_id
        }
    }

    // ✅ Guest → fetch from SESSION
    if (! $is_logged_in && isset($_SESSION['cart'])) {
        foreach ($_SESSION['cart'] as $index => $item) {
            $pid = $item['product_id'];
            $res = mysqli_query($mysqli, "SELECT pname, upc, pthumb FROM product WHERE id='$pid'");
            if ($prod = mysqli_fetch_assoc($res)) {
                $cart_items[] = [
                    'cart_id'    => $index, // use array index as cart_id
                    'product_id' => $pid,
                    'pname'      => $prod['pname'],
                    'upc'        => $prod['upc'],
                    'pthumb'     => $prod['pthumb'],
                    'quantity'   => $item['quantity'],
                ];
                $cart_ids[] = $index; // store session cart_id
            }
        }
    }

    // ✅ Now you can use $cart_ids anywhere
    // Example: store all cart_ids as a comma separated string
    $cart_ids_str = implode(",", $cart_ids);
?>

<!DOCTYPE html>
<html lang="zxx">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="robots" content="index, follow" />
     <title>Craftsy Angel – Where Gifting Meets Creativity</title>
    <meta name="description" content="Mioca - Handmade Goods eCommerce HTML Template" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />

    <link rel="shortcut icon" href="assets/images/favicon/favicon.ico" type="image/png">


    <link rel="stylesheet" href="assets/css/vendor/vendor.min.css" />
    <link rel="stylesheet" href="assets/css/plugins/plugins.min.css" />
    <link rel="stylesheet" href="assets/css/style.min.css">

    </head>

<body>


    <header>
        <div class="header-main sticky-nav ">
            <div class="container position-relative">
                <div class="row">
                    <div class="col-auto align-self-center">
                        <div class="header-logo">
                            <a href="index.html"><img src="assets/images/logo/logo.png" alt="Site Logo" /></a>
                        </div>
                    </div>
                     <div class="col align-self-center d-none d-lg-block">
                            <div class="main-menu">
                                <ul>
                                    <li class="dropdown"><a href="index.php">Home</a>
                                    </li>
                                    <li><a href="about.html">About</a></li>
                                    <li><a href="products.php">Products</a></li>
                                    <li class="dropdown position-static"><a href="#">Shop <i
                                                class="fa fa-angle-down"></i></a>
                                         <ul class="sub-menu">
                                            <li><a href="bags.php">Bags</a></li>
                                            <li><a href="cake_topper.php">Cake Topper</a></li>
                                            <li><a href="hair_clip.php">Hair Clips</a></li>
                                            <li><a href="home_decor.php">Home Decor</a></li>
                                            <li><a href="keychain.php">Keychain</a></li>
                                            <li><a href="nursary_decor.php">Nursary Decor</a></li>
                                            <li><a href="plant_hanging.php">Plant Hanging</a></li>
                                            <li><a href="rainbow.php">Rainbow</a></li>
                                        </ul>
                                    </li>
                                    <li><a href="contact.html">Contact</a></li>
                                </ul>
                            </div>
                        </div>
                     <div class="col col-lg-auto align-self-center pl-0">
                            <div class="header-actions">
                                <a href="#" class="header-action-btn" data-bs-toggle="modal" data-bs-target="#searchActive">
                                    <i class="pe-7s-search"></i>
                                </a>
                                <div class="header-bottom-set dropdown">
                                    <button class="dropdown-toggle header-action-btn" data-bs-toggle="dropdown"><i
                                            class="pe-7s-users"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-right">
                                        <li><a class="dropdown-item" href="my-account.php">My account</a></li>
                                        <li><a class="dropdown-item" href="checkout.php">Checkout</a></li>
                                        <li><a class="dropdown-item" href="login.html">Sign in</a></li>
                                    </ul>
                                </div>
                                <a href="wishlist.php" class="header-action-btn">
                                    <i class="pe-7s-like"></i>
                                    <span class="header-action-num">01</span>
                                </a>
                                <a href="my_cart.php"
                                    class="header-action-btn ">
                                    <i class="pe-7s-shopbag"></i>
                                    <span class="header-action-num">01</span>
                                    </a>

                            </div>
                            </div>
                </div>
            </div>
        </div>
    </header>
    <div class="offcanvas-overlay"></div>


    <div class="breadcrumb-area">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <h2 class="breadcrumb-title">Cart</h2>
                    <ul class="breadcrumb-list">
                        <li class="breadcrumb-item"><a href="index.html">Home</a></li>
                        <li class="breadcrumb-item active">Cart</li>
                    </ul>
                    </div>
            </div>
        </div>
    </div>
    <div class="cart-main-area pt-100px pb-100px">
        <div class="container">
            <h3 class="cart-page-title">Your cart items</h3>
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                    <form action="#">
                       <div class="table-content table-responsive cart-table-content">
    <table>
        <thead>
            <tr>
                <th>Image</th>
                <th>Product Name</th>
                <th>Until Price</th>
                <th>Qty</th>
                <th>Subtotal</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $grand_total = 0;
                foreach ($cart_items as $row):
                    $subtotal = $row['upc'] * $row['quantity'];
                    $grand_total += $subtotal;
                ?>
			            <tr>
			                <td class="product-thumbnail">
			                    <a href="#"><img class="img-responsive ml-15px" src="Admin/Uploads/thumb/<?php echo $row['pthumb']; ?>" alt="" /></a>
			                </td>
			                <td class="product-name"><a href="#"><?php echo $row['pname']; ?></a></td>
			                <td class="product-price-cart"><span class="amount" data-price="<?php echo $row['upc']; ?>">$<?php echo number_format($row['upc'], 2); ?></span></td>
			                <td class="product-quantity">
			                    <div class="cart-plus-minus">
			                        <input class="cart-plus-minus-box" type="text" name="qtybutton" value="<?php echo $row['quantity']; ?>" data-cart-id="<?php echo $row['cart_id']; ?>" />
			                    </div>
			                </td>
			                <td class="product-subtotal"><span class="amount subtotal-amount">$<?php echo number_format($subtotal, 2); ?></span></td>
			                <td class="product-remove">

			                    <a href="delete_cart.php?id=<?php echo $row['cart_id']; ?>"><i class="fa fa-times"></i></a>
			                </td>
			            </tr>
			           <?php endforeach; ?>

        </tbody>
    </table>
</div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="cart-shiping-update-wrapper">
                                    <div class="cart-shiping-update">
                                        <a href="products.php">Continue Shopping</a>
                                    </div>
                                    <div class="cart-clear">
                                        <button>Update Shopping Cart</button>
                                        <a href="clear_cart.php">Clear Shopping Cart</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="row">


                        <div class="col-lg-12 col-md-12 mt-md-30px">
                            <div class="grand-totall">
                                <div class="title-wrap">
                                    <h4 class="cart-bottom-title section-bg-gary-cart">Cart Total</h4>
                                </div>
                                <h5>Total products <span>$<?php echo number_format($grand_total, 2); ?></span></h5>
                                <div class="total-shipping">
                                    <h5>Total shipping</h5>
                                    <ul>
                                        <li><input type="checkbox" /> Standard <span>$20.00</span></li>
                                        <li><input type="checkbox" /> Express <span>$30.00</span></li>
                                         <li><input type="checkbox" /> Free Shipping <span>$00.00</span></li>
                                    </ul>
                                </div>
                                <h4 class="grand-totall-title">Grand Total <span id="grandTotal">$<?php echo number_format($grand_total, 2); ?></span></h4>
                              <!-- Pass cart ids to checkout button -->
                                <a href="checkout.php?cart_ids=<?php echo urlencode($cart_ids_str); ?>">Proceed to Checkout</a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="newsletter-area ">
        <div class="container line-shape-bottom">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="newsletter-content mb-lm-30px">
                        <i class="pe-7s-mail-open-file"></i>
                        <div class="newsletter-text">
                            <h3 class="title">Newsletter & Get Updates</h3>
                            <p>Sign up for our newsletter to get update from us</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="news-letter-form">
                        <div id="mc_embed_signup" class="subscribe-form">
                            <form id="mc-embedded-subscribe-form" class="validate" novalidate="" target="_blank"
                                name="mc-embedded-subscribe-form" method="post"
                                action="http://devitems.us11.list-manage.com/subscribe/post?u=6bbb9b6f5827bd842d9640c82&amp;id=05d85f18ef"
                                >
                                <div id="mc_embed_signup_scroll" class="mc-form">
                                    <input class="email" type="email" required=""
                                        placeholder="Enter Your Mail Here......." name="EMAIL" value="">
                                    <div class="mc-news d-none" aria-hidden="true">
                                        <input type="text" value="" tabindex="-1"
                                            name="b_6bbb9b6f5827bd842d9640c82_05d85f18ef">
                                    </div>
                                    <div class="clear">
                                        <button id="mc-embedded-subscribe" class="button" type="submit" name="subscribe"
                                            value=""> Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer-area">
        <div class="footer-container">
            <div class="footer-top">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6 col-sm-6 col-lg-3 mb-md-30px mb-lm-30px">
                            <div class="single-wedge">
                                <h4 class="footer-herading">Information</h4>
                                <div class="footer-links">
                                    <div class="footer-row">
                                        <ul class="align-items-center">
                                            <li class="li"><a class="single-link" href="about.html">About us</a></li>
                                            <li class="li"><a class="single-link" href="#">Delivery information</a></li>
                                            <li class="li"><a class="single-link" href="privacy-policy.html">Privacy
                                                    Policy</a></li>
                                            <li class="li"><a class="single-link" href="#">Sales</a></li>
                                            <li class="li"><a class="single-link" href="#">Terms & Conditions</a></li>
                                            <li class="li"><a class="single-link" href="#">Shipping Policy</a></li>
                                            <li class="li"><a class="single-link" href="#">EMI Payment</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 col-sm-6 mb-lm-30px">
                            <div class="single-wedge">
                                <h4 class="footer-herading">Account</h4>
                                <div class="footer-links">
                                    <div class="footer-row">
                                        <ul class="align-items-center">
                                            <li class="li"><a class="single-link" href="my-account.php"> My account</a>
                                            </li>
                                            <li class="li"><a class="single-link" href="my_cart.php">My orders</a></li>
                                            <li class="li"><a class="single-link" href="#">Returns</a></li>
                                            <li class="li"><a class="single-link"
                                                    href="products.php">Shipping</a></li>
                                            <li class="li"><a class="single-link" href="wishlist.php">Wishlist</a></li>
                                            <li class="li"><a class="single-link" href="#">How Does It Work</a></li>
                                            <li class="li"><a class="single-link" href="#">Merchant Sign Up</a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-2 col-sm-6 mb-sm-30px">
                            <div class="single-wedge">
                                <h4 class="footer-herading">Store </h4>
                                <div class="footer-links">
                                    <div class="footer-row">
                                        <ul class="align-items-center">
                                            <li class="li"><a class="single-link" href="index.html">Affiliate</a></li>
                                            <li class="li"><a class="single-link"
                                                    href="products.php">Bestsellers</a></li>
                                            <li class="li"><a class="single-link" href="#">Discount</a></li>
                                            <li class="li"><a class="single-link" href="#">Latest products</a></li>
                                            <li class="li"><a class="single-link" href="#">Sale</a></li>
                                            <li class="li"><a class="single-link" href="#">All Collection</a></li>
                                            <li class="li"><a class="single-link" href="contact.html">Contact Us</a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-4 col-sm-6 pl-120px line-shape">
                            <div class="single-wedge ">

                                <h4 class="footer-herading">Contact Us</h4>
                                <div class="footer-links">
                                    <p class="mail">If you have any question.please <br>
                                        contact us at <a href="mailto:demo@example.com">demo@example.com</a> </p>
                                    <p class="address"><i class="pe-7s-map-marker"></i> <span>Your address goes here.
                                            <br>
                                            123, Address.</span> </p>
                                    <p class="phone m-0"><i class="pe-7s-phone"></i><span><a href="tel:0123456789">+ 0
                                                123
                                                456 789</a> <br> <a href="tel:0123456789">+ 0 123 456 789</a></span></p>

                                    </div>
                            </div>
                        </div>
                        </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="container">
                    <div class="line-shape-top">
                        <div class="row flex-md-row-reverse align-items-center">
                            <div class="col-md-6 text-center text-md-end">
                                <div class="payment-mth"><a href="#"><img class="img img-fluid"
                                            src="assets/images/icons/payment.png" alt="payment-image"></a></div>
                            </div>
                            <div class="col-md-6 text-center text-md-start">
                                <p class="copy-text"> © 2021 <strong>Mioca.</strong> Made With <i class="fa fa-heart"
                                        aria-hidden="true"></i> By <a class="company-name"
                                        href="https://hasthemes.com/">
                                        <strong> HasThemes</strong></a>.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Search Modal Start -->
<div class="modal popup-search-style" id="searchActive">
    <button type="button" class="close-btn" data-bs-dismiss="modal">
        <span aria-hidden="true">&times;</span>
    </button>
    <div class="modal-overlay">
        <div class="modal-dialog p-0" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <h2>Search Your Product</h2>
                    <form class="navbar-form position-relative" role="search" method="GET" action="search.php">
                        <div class="form-group">
                            <input type="text" name="q" class="form-control" placeholder="Search here..." required>
                        </div>
                        <button type="submit" class="submit-btn"><i class="pe-7s-search"></i></button>
                    </form>
                    <p id="searchMsg" style="color:red; display:none;">Not Found!</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Search Modal End -->
    <script src="assets/js/vendor/vendor.min.js"></script>
    <script src="assets/js/plugins/plugins.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
       document.addEventListener('DOMContentLoaded', function() {
    const qtyInputs = document.querySelectorAll('.cart-plus-minus-box');
    const updateCartButton = document.querySelector('.cart-clear button');

    // Function to update cart totals via AJAX and reload the page
    const updateCartTotals = async (cartId, newQuantity) => {
        const url = 'update_cart.php';
        const data = new FormData();
        data.append('cart_id', cartId);
        data.append('quantity', newQuantity);

        try {
            const response = await fetch(url, {
                method: 'POST',
                body: data
            });
            const result = await response.json();

            if (result.status === 'success') {
                // Reload the page to display the updated data from the database
                window.location.reload();
            } else {
                console.error('Error updating cart:', result.message);
                alert('Failed to update cart. Please try again.');
            }
        } catch (error) {
            console.error('Fetch error:', error);
            alert('An error occurred. Please check your connection and try again.');
        }
    };

    // Event listener for "Update Shopping Cart" button
    updateCartButton.addEventListener('click', function(e) {
        e.preventDefault(); // Prevent form submission

        qtyInputs.forEach(input => {
            const cartId = input.dataset.cartId;
            const newQuantity = parseInt(input.value, 10);

            // Only update if the quantity has changed and is a valid number
            if (!isNaN(newQuantity) && newQuantity > 0 && newQuantity !== parseInt(input.defaultValue, 10)) {
                updateCartTotals(cartId, newQuantity);
            }
        });
    });
});
    </script>
</body>

</html>