<?php
session_start();
require 'dbconn.php'; // your DB connection

// Ensure user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Get form data safely
$id_gender   = isset($_POST['id_gender']) ? (int) $_POST['id_gender'] : 0;
$username    = trim($_POST['first-name'] ?? '');
$phone       = trim($_POST['last-name'] ?? '');
$email       = trim($_POST['email-name'] ?? '');
$birthday    = trim($_POST['birthday'] ?? '');

// Simple validation
$errors = [];

if ($id_gender < 1 || $id_gender > 2) {
    $errors[] = "Invalid gender selected.";
}

if (empty($username)) {
    $errors[] = "Name is required.";
}

if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $errors[] = "Invalid email format.";
}

// Convert birthday to correct format or null
if (!empty($birthday)) {
    $birthday = date('Y-m-d', strtotime($birthday));
} else {
    $birthday = null;
}

// If no errors, update user data
if (empty($errors)) {
    $sql = "UPDATE users 
            SET gender = ?, username = ?, phone = ?, email = ?, birthday = ? 
            WHERE id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param("issssi", $id_gender, $username, $phone, $email, $birthday, $user_id);

    if ($stmt->execute()) {
        $_SESSION['success_msg'] = "Account updated successfully.";

        // ✅ Send confirmation email
        $to = $email;
        $subject = "Profile Updated Successfully";

        $message = "
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin:0; padding:0; }
                .container { max-width: 500px; margin: 30px auto; background: #fff; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 10px rgba(0,0,0,0.1);}
                .header { background: #4CAF50; padding: 30px; text-align: center; color: #fff; }
                .header .checkmark { font-size: 50px; }
                .content { padding: 20px; text-align: center; }
                .content h2 { color: #333; margin-bottom: 10px; }
                .content p { color: #666; font-size: 14px; line-height: 1.6; }
                .btn { display: inline-block; margin-top: 20px; padding: 12px 20px; background: #4CAF50; color: #fff; text-decoration: none; border-radius: 5px; font-weight: bold;}
                .btn:hover { background: #388E3C; }
                .footer { margin-top: 20px; font-size: 12px; color: #999; text-align: center; padding: 10px;}
            </style>
        </head>
        <body>
            <div class='container'>
                <div class='header'>
                    <div class='checkmark'>✔</div>
                </div>
                <div class='content'>
                    <h2>Profile Updated Successfully!</h2>
                    <p>Hello <strong>$username</strong>, your profile details have been updated successfully.</p>
                    <a href='http://yourwebsite.com/my-account.php' class='btn'>View My Account</a>
                </div>
                <div class='footer'>
                    &copy; " . date("Y") . " Your Company Name. All rights reserved.
                </div>
            </div>
        </body>
        </html>";

        // Headers
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: Your Company <no-reply@yourwebsite.com>" . "\r\n";

        // Send email
        mail($to, $subject, $message, $headers);

    } else {
        $_SESSION['error_msg'] = "Error updating account: " . $stmt->error;
    }

    header("Location: my-account.php"); // redirect back to profile page
    exit;
} else {
    $_SESSION['error_msg'] = implode("<br>", $errors);
    header("Location: my-account.php");
    exit;
}
?>
